/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.sample.graphene;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.epics.graphene.NumberColorMap;
import org.epics.graphene.NumberColorMaps;
import org.epics.pvmanager.sample.graphene.IntensityGraphApp;

public class IntensityGraphDialog
extends JDialog {
    private final IntensityGraphApp graph;
    private JComboBox<String> colorSchemeField;
    private JCheckBox drawLegendField;
    private JLabel jLabel1;

    public IntensityGraphDialog(Frame parent, boolean modal, IntensityGraphApp graph) {
        super(parent, modal);
        this.graph = graph;
        this.initComponents();
        this.colorSchemeField.setModel(new DefaultComboBoxModel<String>(new ArrayList(NumberColorMaps.getRegisteredColorSchemes().keySet()).toArray(new String[0])));
        if (graph != null) {
            String currentName = null;
            for (Map.Entry entry : NumberColorMaps.getRegisteredColorSchemes().entrySet()) {
                String string = (String)entry.getKey();
                NumberColorMap numberColorMap = (NumberColorMap)entry.getValue();
                if (numberColorMap != graph.getColorMap()) continue;
                currentName = string;
            }
            this.colorSchemeField.setSelectedItem(currentName);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.colorSchemeField = new JComboBox();
        this.drawLegendField = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("Color Scheme:");
        this.colorSchemeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntensityGraphDialog.this.colorSchemeFieldActionPerformed(evt);
            }
        });
        this.drawLegendField.setText("Draw Legend");
        this.drawLegendField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntensityGraphDialog.this.drawLegendFieldActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.colorSchemeField, 0, 279, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.drawLegendField).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.colorSchemeField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.drawLegendField).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void colorSchemeFieldActionPerformed(ActionEvent evt) {
        this.graph.setColorMap((NumberColorMap)NumberColorMaps.getRegisteredColorSchemes().get(this.colorSchemeField.getSelectedItem()));
    }

    private void drawLegendFieldActionPerformed(ActionEvent evt) {
        this.graph.setDrawLegend(this.drawLegendField.isSelected());
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(IntensityGraphDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(IntensityGraphDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(IntensityGraphDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(IntensityGraphDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                IntensityGraphDialog dialog = new IntensityGraphDialog((Frame)new JFrame(), true, null);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

