/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.sample.graphene;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.epics.graphene.InterpolationScheme;
import org.epics.graphene.LineGraph2DRendererUpdate;
import org.epics.pvmanager.CompositeDataSource;
import org.epics.pvmanager.DataSource;
import org.epics.pvmanager.PVManager;
import org.epics.pvmanager.PVReader;
import org.epics.pvmanager.PVReaderEvent;
import org.epics.pvmanager.PVReaderListener;
import org.epics.pvmanager.expression.DesiredRateExpression;
import org.epics.pvmanager.formula.ExpressionLanguage;
import org.epics.pvmanager.graphene.Graph2DResult;
import org.epics.pvmanager.graphene.LineGraph2DExpression;
import org.epics.pvmanager.jca.JCADataSource;
import org.epics.pvmanager.sample.ImagePanel;
import org.epics.pvmanager.sim.SimulationDataSource;
import org.epics.pvmanager.util.Executors;
import org.epics.util.time.TimeDuration;
import org.epics.vtype.VImage;
import org.epics.vtype.ValueUtil;

public class LineGraphSample
extends JFrame {
    private PVReader<Graph2DResult> pv;
    private LineGraph2DExpression plot;
    final BufferedImage finalBuffer = new BufferedImage(100, 100, 5);
    private JTextField dataFormulaField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JSeparator jSeparator1;
    private JTextField lastError;
    private ImagePanel plotView;
    private JTextField tooltipColumnField;
    private JTextField xColumnField;
    private JTextField yColumnField;

    public LineGraphSample() {
        PVManager.setDefaultNotificationExecutor((Executor)Executors.swingEDT());
        CompositeDataSource dataSource = new CompositeDataSource();
        dataSource.putDataSource("sim", SimulationDataSource.simulatedData());
        dataSource.putDataSource("epics", (DataSource)new JCADataSource());
        dataSource.setDefaultDataSource("sim");
        PVManager.setDefaultDataSource((DataSource)dataSource);
        this.initComponents();
        this.plotView.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (LineGraphSample.this.plot != null) {
                    LineGraphSample.this.plot.update((LineGraph2DRendererUpdate)((LineGraph2DRendererUpdate)new LineGraph2DRendererUpdate().imageHeight(LineGraphSample.this.plotView.getHeight())).imageWidth(LineGraphSample.this.plotView.getWidth()));
                }
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.dataFormulaField = new JTextField();
        this.lastError = new JTextField();
        this.plotView = new ImagePanel();
        this.jLabel2 = new JLabel();
        this.xColumnField = new JTextField();
        this.jLabel3 = new JLabel();
        this.yColumnField = new JTextField();
        this.jLabel4 = new JLabel();
        this.tooltipColumnField = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(3);
        this.jLabel1.setText("Data Formula:");
        this.dataFormulaField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LineGraphSample.this.dataFormulaFieldActionPerformed(evt);
            }
        });
        this.lastError.setEditable(false);
        GroupLayout plotViewLayout = new GroupLayout(this.plotView);
        this.plotView.setLayout(plotViewLayout);
        plotViewLayout.setHorizontalGroup(plotViewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 497, Short.MAX_VALUE));
        plotViewLayout.setVerticalGroup(plotViewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 197, Short.MAX_VALUE));
        this.jLabel2.setText("X Column:");
        this.xColumnField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LineGraphSample.this.xColumnFieldActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Y Column:");
        this.yColumnField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LineGraphSample.this.yColumnFieldActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Tooltip Column:");
        this.tooltipColumnField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LineGraphSample.this.tooltipColumnFieldActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.dataFormulaField).addGap(12, 12, 12)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.plotView, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.lastError)).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.xColumnField).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.yColumnField).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tooltipColumnField).addContainerGap()))).addComponent(this.jSeparator1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.dataFormulaField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.xColumnField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.yColumnField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.tooltipColumnField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.plotView, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lastError, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void dataFormulaFieldActionPerformed(ActionEvent evt) {
        if (this.pv != null) {
            this.pv.close();
            this.plotView.setImage(null);
            this.plot = null;
        }
        if (this.dataFormulaField.getText() == null || this.dataFormulaField.getText().trim().isEmpty()) {
            return;
        }
        if (this.plot == null) {
            this.plot = org.epics.pvmanager.graphene.ExpressionLanguage.lineGraphOf((DesiredRateExpression)ExpressionLanguage.formula((String)this.dataFormulaField.getText()), (DesiredRateExpression)ExpressionLanguage.formulaArg((String)this.xColumnField.getText()), (DesiredRateExpression)ExpressionLanguage.formulaArg((String)this.yColumnField.getText()), (DesiredRateExpression)ExpressionLanguage.formulaArg((String)this.tooltipColumnField.getText()));
        }
        this.plot.update(((LineGraph2DRendererUpdate)((LineGraph2DRendererUpdate)new LineGraph2DRendererUpdate().imageHeight(this.plotView.getHeight())).imageWidth(this.plotView.getWidth())).interpolation(InterpolationScheme.LINEAR));
        this.pv = PVManager.read((DesiredRateExpression)this.plot).notifyOn(Executors.swingEDT()).readListener((PVReaderListener)new PVReaderListener<Graph2DResult>(){

            public void pvChanged(PVReaderEvent<Graph2DResult> event) {
                LineGraphSample.this.setLastError(LineGraphSample.this.pv.lastException());
                if (LineGraphSample.this.pv.getValue() != null) {
                    BufferedImage image = ValueUtil.toImage((VImage)((Graph2DResult)LineGraphSample.this.pv.getValue()).getImage());
                    LineGraphSample.this.plotView.setImage(image);
                }
            }
        }).maxRate(TimeDuration.ofHertz((double)50.0));
    }

    private void yColumnFieldActionPerformed(ActionEvent evt) {
        this.dataFormulaFieldActionPerformed(evt);
    }

    private void tooltipColumnFieldActionPerformed(ActionEvent evt) {
        this.dataFormulaFieldActionPerformed(evt);
    }

    private void xColumnFieldActionPerformed(ActionEvent evt) {
        this.dataFormulaFieldActionPerformed(evt);
    }

    private void setLastError(Exception ex) {
        if (ex != null) {
            this.lastError.setText(ex.getMessage());
            ex.printStackTrace();
            Logger.getLogger(LineGraphSample.class.getName()).log(Level.WARNING, "Error", ex);
        } else {
            this.lastError.setText("");
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new LineGraphSample().setVisible(true);
            }
        });
    }
}

