/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.sample.graphene;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.epics.graphene.InterpolationScheme;
import org.epics.graphene.LineGraph2DRenderer;
import org.epics.pvmanager.sample.SwingBindingUtil;
import org.epics.pvmanager.sample.graphene.MultiAxisLineGraphApp;

public class MultiAxisLineGraphDialog
extends JDialog {
    private final MultiAxisLineGraphApp graph;
    private JComboBox<InterpolationScheme> interpolationSchemeField;
    private JLabel jLabel1;
    private JCheckBox separateAreasField;

    public MultiAxisLineGraphDialog(Frame parent, boolean modal, final MultiAxisLineGraphApp graph) {
        super(parent, modal);
        this.graph = graph;
        this.initComponents();
        this.interpolationSchemeField.setModel(new DefaultComboBoxModel<InterpolationScheme>(LineGraph2DRenderer.supportedInterpolationScheme.toArray(new InterpolationScheme[0])));
        if (graph != null) {
            this.interpolationSchemeField.setSelectedItem(graph.getInterpolationScheme());
        }
        SwingBindingUtil.onCheckBoxChange(this.separateAreasField, new Runnable(){

            @Override
            public void run() {
                graph.setSeparateAreas(MultiAxisLineGraphDialog.this.separateAreasField.isSelected());
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.interpolationSchemeField = new JComboBox();
        this.separateAreasField = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("Interpolation:");
        this.interpolationSchemeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiAxisLineGraphDialog.this.interpolationSchemeFieldActionPerformed(evt);
            }
        });
        this.separateAreasField.setText("Separate Areas");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.separateAreasField).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.interpolationSchemeField, 0, 287, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.interpolationSchemeField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.separateAreasField).addContainerGap(62, Short.MAX_VALUE)));
        this.pack();
    }

    private void interpolationSchemeFieldActionPerformed(ActionEvent evt) {
        if (this.graph != null) {
            this.graph.setInterpolationScheme((InterpolationScheme)this.interpolationSchemeField.getSelectedItem());
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MultiAxisLineGraphDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MultiAxisLineGraphDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MultiAxisLineGraphDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MultiAxisLineGraphDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MultiAxisLineGraphDialog dialog = new MultiAxisLineGraphDialog((Frame)new JFrame(), true, null);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

