/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.sample.graphene;

import java.awt.Frame;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFrame;
import org.epics.graphene.Graph2DRendererUpdate;
import org.epics.graphene.InterpolationScheme;
import org.epics.graphene.LineGraph2DRendererUpdate;
import org.epics.pvmanager.expression.DesiredRateExpression;
import org.epics.pvmanager.formula.ExpressionLanguage;
import org.epics.pvmanager.graphene.MultilineGraph2DExpression;
import org.epics.pvmanager.sample.graphene.BaseGraphApp;
import org.epics.pvmanager.sample.graphene.MultilineGraphDialog;

public class MultilineGraphApp
extends BaseGraphApp<LineGraph2DRendererUpdate> {
    private InterpolationScheme interpolationScheme = InterpolationScheme.NEAREST_NEIGHBOR;

    public MultilineGraphApp() {
        this.dataFormulaField.setModel(new DefaultComboBoxModel<String>(new String[]{"=tableOf(column(\"Sine\", 'sim://sineWaveform(1,50,100,0.01)'), column(\"Triangle\", 'sim://triangleWaveform(2,50,100,0.01)'), column(\"Triangle\", 'sim://squareWaveform(3,50,100,0.01)'))", "sim://gaussianWaveform", "sim://sineWaveform", "sim://triangleWaveform", "=tableOf(column(\"X\", range(-5, 5)), column(\"Y\", 'sim://gaussianWaveform'))"}));
    }

    public InterpolationScheme getInterpolationScheme() {
        return this.interpolationScheme;
    }

    public void setInterpolationScheme(InterpolationScheme interpolationScheme) {
        this.interpolationScheme = interpolationScheme;
        if (this.graph != null) {
            this.graph.update((Graph2DRendererUpdate)((LineGraph2DRendererUpdate)this.graph.newUpdate()).interpolation(interpolationScheme));
        }
    }

    protected MultilineGraph2DExpression createExpression(String dataFormula) {
        MultilineGraph2DExpression plot = org.epics.pvmanager.graphene.ExpressionLanguage.multilineGraphOf((DesiredRateExpression)ExpressionLanguage.formula((String)dataFormula), null, null);
        plot.update(plot.newUpdate().interpolation(this.interpolationScheme));
        return plot;
    }

    @Override
    protected void openConfigurationDialog() {
        MultilineGraphDialog dialog = new MultilineGraphDialog((Frame)new JFrame(), true, this);
        dialog.setTitle("Configure...");
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    public static void main(String[] args) {
        MultilineGraphApp.main(MultilineGraphApp.class);
    }
}

