/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.sample.graphene;

import java.awt.Frame;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFrame;
import org.epics.graphene.Graph2DRendererUpdate;
import org.epics.graphene.InterpolationScheme;
import org.epics.graphene.ScatterGraph2DRendererUpdate;
import org.epics.pvmanager.expression.DesiredRateExpression;
import org.epics.pvmanager.formula.ExpressionLanguage;
import org.epics.pvmanager.graphene.ScatterGraph2DExpression;
import org.epics.pvmanager.sample.graphene.BaseGraphApp;
import org.epics.pvmanager.sample.graphene.ScatterGraphDialog;

public class ScatterGraphApp
extends BaseGraphApp<ScatterGraph2DRendererUpdate> {
    private InterpolationScheme interpolationScheme = InterpolationScheme.NONE;

    public ScatterGraphApp() {
        this.dataFormulaField.setModel(new DefaultComboBoxModel<String>(new String[]{"sim://table", "=tableOf(column(\"X\", step(0, 1)), column(\"Y\", 'sim://gaussianWaveform'))", "=tableOf(column(\"X\", 'sim://sineWaveform(1,100,100,0.01)'), column(\"Y\", 'sim://sineWaveform(10,100,100,0.01)'))", "=tableOf(column(\"X\", 'sim://triangleWaveform(10,100,100,0.01)'), column(\"Y\", 'sim://triangleWaveform(20,100,100,0.01)'))"}));
    }

    public InterpolationScheme getInterpolationScheme() {
        return this.interpolationScheme;
    }

    public void setInterpolationScheme(InterpolationScheme interpolationScheme) {
        this.interpolationScheme = interpolationScheme;
        if (this.graph != null) {
            this.graph.update((Graph2DRendererUpdate)((ScatterGraph2DRendererUpdate)this.graph.newUpdate()).interpolation(interpolationScheme));
        }
    }

    protected ScatterGraph2DExpression createExpression(String dataFormula) {
        ScatterGraph2DExpression plot = org.epics.pvmanager.graphene.ExpressionLanguage.scatterGraphOf((DesiredRateExpression)ExpressionLanguage.formula((String)dataFormula), null, null, null);
        plot.update(plot.newUpdate().interpolation(this.interpolationScheme));
        return plot;
    }

    @Override
    protected void openConfigurationDialog() {
        ScatterGraphDialog dialog = new ScatterGraphDialog((Frame)new JFrame(), true, this);
        dialog.setTitle("Configure...");
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    public static void main(String[] args) {
        ScatterGraphApp.main(ScatterGraphApp.class);
    }
}

