/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.sample.jca;

import org.epics.pvmanager.DataSource;
import org.epics.pvmanager.ExpressionLanguage;
import org.epics.pvmanager.PVManager;
import org.epics.pvmanager.PVReader;
import org.epics.pvmanager.PVReaderEvent;
import org.epics.pvmanager.PVReaderListener;
import org.epics.pvmanager.expression.SourceRateExpression;
import org.epics.pvmanager.jca.JCADataSourceBuilder;
import org.epics.util.time.TimeDuration;
import org.epics.vtype.VByteArray;
import org.epics.vtype.VDouble;
import org.epics.vtype.VDoubleArray;
import org.epics.vtype.VEnum;
import org.epics.vtype.VFloatArray;
import org.epics.vtype.VInt;
import org.epics.vtype.VIntArray;
import org.epics.vtype.VShortArray;
import org.epics.vtype.VString;
import org.epics.vtype.VStringArray;

public class JCAClientExample {
    private static final String doublePV = "counter1";
    private static final String enumPV = "counter1.SCAN";
    private static final String intPV = "counter1.RVAL";
    private static final String stringPV = "counter1.EGU";
    private static final String doubleArrayPV = "SR:C00-Glb:G00<BETA:00>RB-X";

    public static void main(String[] args) throws Exception {
        System.out.println(Double.NEGATIVE_INFINITY);
        System.out.println(System.getProperty("java.library.path"));
        System.loadLibrary("jca");
        PVManager.setDefaultDataSource((DataSource)new JCADataSourceBuilder().jcaContextClass("gov.aps.jca.jni.ThreadSafeContext").build());
        PVReader pvReader = PVManager.read((SourceRateExpression)ExpressionLanguage.channel((String)doublePV)).readListener((PVReaderListener)new PVReaderListener<Object>(){

            public void pvChanged(PVReaderEvent<Object> event) {
                System.out.println(event.getPvReader().getValue());
            }
        }).maxRate(TimeDuration.ofMillis((int)100));
        Thread.sleep(5000L);
        pvReader.close();
    }

    private static void logException(Exception ex) {
        if (ex != null) {
            ex.printStackTrace(System.out);
        }
    }

    private static void testNativeTypeSupport() throws Exception {
        PVReader pv = PVManager.read((SourceRateExpression)ExpressionLanguage.channel((String)doublePV)).maxRate(TimeDuration.ofHertz((double)10.0));
        Thread.sleep(250L);
        JCAClientExample.logException(pv.lastException());
        VDouble value = (VDouble)pv.getValue();
        System.out.println(value.getClass());
        pv.close();
        pv = PVManager.read((SourceRateExpression)ExpressionLanguage.channel((String)stringPV)).maxRate(TimeDuration.ofHertz((double)10.0));
        Thread.sleep(250L);
        JCAClientExample.logException(pv.lastException());
        value = (VString)pv.getValue();
        System.out.println(value.getClass());
        pv.close();
        pv = PVManager.read((SourceRateExpression)ExpressionLanguage.channel((String)enumPV)).maxRate(TimeDuration.ofHertz((double)10.0));
        Thread.sleep(250L);
        JCAClientExample.logException(pv.lastException());
        value = (VEnum)pv.getValue();
        System.out.println(value.getClass());
        pv.close();
        pv = PVManager.read((SourceRateExpression)ExpressionLanguage.channel((String)intPV)).maxRate(TimeDuration.ofHertz((double)10.0));
        Thread.sleep(250L);
        JCAClientExample.logException(pv.lastException());
        value = (VInt)pv.getValue();
        System.out.println(value.getClass());
        pv.close();
        pv = PVManager.read((SourceRateExpression)ExpressionLanguage.channel((String)doubleArrayPV)).maxRate(TimeDuration.ofHertz((double)10.0));
        Thread.sleep(250L);
        JCAClientExample.logException(pv.lastException());
        value = (VDoubleArray)pv.getValue();
        System.out.println(value.getClass());
        pv.close();
    }

    private static void testVFloatArraySupport() throws Exception {
        PVReader pv = PVManager.read((SourceRateExpression)org.epics.pvmanager.vtype.ExpressionLanguage.vFloatArray((String)doublePV)).readListener((PVReaderListener)new PVReaderListener<VFloatArray>(){

            public void pvChanged(PVReaderEvent<VFloatArray> event) {
                PVReader pv = event.getPvReader();
                System.out.println(((VFloatArray)pv.getValue()).getData() + " " + ((VFloatArray)pv.getValue()).getTimestamp().toDate() + " " + ((VFloatArray)pv.getValue()).getAlarmSeverity());
            }
        }).maxRate(TimeDuration.ofHertz((double)10.0));
        Thread.sleep(10000L);
        pv.close();
    }

    private static void testVDoubleArraySupport() throws Exception {
        PVReader pv = PVManager.read((SourceRateExpression)org.epics.pvmanager.vtype.ExpressionLanguage.vDoubleArray((String)doubleArrayPV)).readListener((PVReaderListener)new PVReaderListener<VDoubleArray>(){

            public void pvChanged(PVReaderEvent<VDoubleArray> event) {
                PVReader pv = event.getPvReader();
                JCAClientExample.logException(pv.lastException());
                if (pv.getValue() != null) {
                    System.out.println(((VDoubleArray)pv.getValue()).getData() + " " + ((VDoubleArray)pv.getValue()).getTimestamp().toDate() + " " + ((VDoubleArray)pv.getValue()).getAlarmSeverity());
                }
            }
        }).maxRate(TimeDuration.ofHertz((double)10.0));
        Thread.sleep(10000L);
        pv.close();
    }

    private static void testVByteArraySupport() throws Exception {
        PVReader pv = PVManager.read((SourceRateExpression)org.epics.pvmanager.vtype.ExpressionLanguage.vByteArray((String)doublePV)).readListener((PVReaderListener)new PVReaderListener<VByteArray>(){

            public void pvChanged(PVReaderEvent<VByteArray> event) {
                PVReader pv = event.getPvReader();
                System.out.println(((VByteArray)pv.getValue()).getData() + " " + ((VByteArray)pv.getValue()).getTimestamp().toDate() + " " + ((VByteArray)pv.getValue()).getAlarmSeverity());
            }
        }).maxRate(TimeDuration.ofHertz((double)10.0));
        Thread.sleep(10000L);
        pv.close();
    }

    private static void testVShortArraySupport() throws Exception {
        PVReader pv = PVManager.read((SourceRateExpression)org.epics.pvmanager.vtype.ExpressionLanguage.vShortArray((String)doublePV)).readListener((PVReaderListener)new PVReaderListener<VShortArray>(){

            public void pvChanged(PVReaderEvent<VShortArray> event) {
                PVReader pv = event.getPvReader();
                System.out.println(((VShortArray)pv.getValue()).getData() + " " + ((VShortArray)pv.getValue()).getTimestamp().toDate() + " " + ((VShortArray)pv.getValue()).getAlarmSeverity());
            }
        }).maxRate(TimeDuration.ofHertz((double)10.0));
        Thread.sleep(10000L);
        pv.close();
    }

    private static void testVIntArraySupport() throws Exception {
        PVReader pv = PVManager.read((SourceRateExpression)org.epics.pvmanager.vtype.ExpressionLanguage.vIntArray((String)doublePV)).readListener((PVReaderListener)new PVReaderListener<VIntArray>(){

            public void pvChanged(PVReaderEvent<VIntArray> event) {
                PVReader pv = event.getPvReader();
                JCAClientExample.logException(pv.lastException());
                System.out.println(((VIntArray)pv.getValue()).getData() + " " + ((VIntArray)pv.getValue()).getTimestamp().toDate() + " " + ((VIntArray)pv.getValue()).getAlarmSeverity());
            }
        }).maxRate(TimeDuration.ofHertz((double)10.0));
        Thread.sleep(10000L);
        pv.close();
    }

    private static void testVStringArraySupport() throws Exception {
        PVReader pv = PVManager.read((SourceRateExpression)org.epics.pvmanager.vtype.ExpressionLanguage.vStringArray((String)doublePV)).readListener((PVReaderListener)new PVReaderListener<VStringArray>(){

            public void pvChanged(PVReaderEvent<VStringArray> event) {
                PVReader pv = event.getPvReader();
                System.out.println(((VStringArray)pv.getValue()).getData() + " " + ((VStringArray)pv.getValue()).getTimestamp().toDate() + " " + ((VStringArray)pv.getValue()).getAlarmSeverity());
            }
        }).maxRate(TimeDuration.ofHertz((double)10.0));
        Thread.sleep(10000L);
        pv.close();
    }

    private static void testVDoubleSupport() throws Exception {
        PVReader pv = PVManager.read((SourceRateExpression)org.epics.pvmanager.vtype.ExpressionLanguage.vDouble((String)doublePV)).readListener((PVReaderListener)new PVReaderListener<VDouble>(){

            public void pvChanged(PVReaderEvent<VDouble> event) {
                PVReader pv = event.getPvReader();
                System.out.println(((VDouble)pv.getValue()).getValue() + " " + ((VDouble)pv.getValue()).getTimestamp().toDate() + " " + ((VDouble)pv.getValue()).getAlarmSeverity());
            }
        }).maxRate(TimeDuration.ofHertz((double)10.0));
        Thread.sleep(10000L);
        pv.close();
    }

    private static void testVIntSupport() throws Exception {
        PVReader pv = PVManager.read((SourceRateExpression)org.epics.pvmanager.vtype.ExpressionLanguage.vInt((String)intPV)).readListener((PVReaderListener)new PVReaderListener<VInt>(){

            public void pvChanged(PVReaderEvent<VInt> event) {
                PVReader pv = event.getPvReader();
                System.out.println(((VInt)pv.getValue()).getValue() + " " + ((VInt)pv.getValue()).getTimestamp().toDate() + " " + ((VInt)pv.getValue()).getAlarmSeverity());
            }
        }).maxRate(TimeDuration.ofHertz((double)10.0));
        Thread.sleep(10000L);
        pv.close();
    }

    private static void testVStringSupport() throws Exception {
        PVReader pv = PVManager.read((SourceRateExpression)org.epics.pvmanager.vtype.ExpressionLanguage.vString((String)stringPV)).readListener((PVReaderListener)new PVReaderListener<VString>(){

            public void pvChanged(PVReaderEvent<VString> event) {
                PVReader pv = event.getPvReader();
                JCAClientExample.logException(pv.lastException());
                if (pv.getValue() != null) {
                    System.out.println(((VString)pv.getValue()).getValue() + " " + ((VString)pv.getValue()).getTimestamp().toDate() + " " + ((VString)pv.getValue()).getAlarmSeverity());
                }
            }
        }).maxRate(TimeDuration.ofHertz((double)10.0));
        Thread.sleep(10000L);
        pv.close();
    }

    private static void testVEnumSupport() throws Exception {
        PVReader pv = PVManager.read((SourceRateExpression)org.epics.pvmanager.vtype.ExpressionLanguage.vEnum((String)enumPV)).readListener((PVReaderListener)new PVReaderListener<VEnum>(){

            public void pvChanged(PVReaderEvent<VEnum> event) {
                PVReader pv = event.getPvReader();
                JCAClientExample.logException(pv.lastException());
                if (pv.getValue() != null) {
                    System.out.println(((VEnum)pv.getValue()).getValue() + " " + ((VEnum)pv.getValue()).getTimestamp().toDate() + " " + ((VEnum)pv.getValue()).getAlarmSeverity());
                }
            }
        }).maxRate(TimeDuration.ofHertz((double)10.0));
        Thread.sleep(10000L);
        pv.close();
    }
}

