/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpAuthException;
import com.ericsson.otp.erlang.OtpEpmd;
import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangExit;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangLong;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpErlangString;
import com.ericsson.otp.erlang.OtpErlangTuple;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpLocalNode;
import com.ericsson.otp.erlang.OtpMD5;
import com.ericsson.otp.erlang.OtpMsg;
import com.ericsson.otp.erlang.OtpOutputStream;
import com.ericsson.otp.erlang.OtpPeer;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Random;

public abstract class AbstractConnection
extends Thread {
    protected static final int headerLen = 2048;
    protected static final byte passThrough = 112;
    protected static final byte version = -125;
    protected static final int linkTag = 1;
    protected static final int sendTag = 2;
    protected static final int exitTag = 3;
    protected static final int unlinkTag = 4;
    protected static final int nodeLinkTag = 5;
    protected static final int regSendTag = 6;
    protected static final int groupLeaderTag = 7;
    protected static final int exit2Tag = 8;
    protected static final int sendTTTag = 12;
    protected static final int exitTTTag = 13;
    protected static final int regSendTTTag = 16;
    protected static final int exit2TTTag = 18;
    protected static final int ChallengeReply = 114;
    protected static final int ChallengeAck = 97;
    protected static final int ChallengeStatus = 115;
    private volatile boolean done = false;
    protected boolean connected = false;
    protected Socket socket;
    protected OtpPeer peer;
    protected OtpLocalNode self;
    String name;
    protected boolean cookieOk = false;
    protected boolean sendCookie = true;
    protected int traceLevel = 0;
    protected static int defaultLevel = 0;
    protected static int sendThreshold = 1;
    protected static int ctrlThreshold = 2;
    protected static int handshakeThreshold = 3;
    protected static Random random = null;
    private int flags = 0;

    protected AbstractConnection(OtpLocalNode self, Socket s) throws IOException, OtpAuthException {
        this.self = self;
        this.peer = new OtpPeer();
        this.socket = s;
        this.socket.setTcpNoDelay(true);
        this.traceLevel = defaultLevel;
        this.setDaemon(true);
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("<- ACCEPT FROM " + s.getInetAddress() + ":" + s.getPort());
        }
        this.recvName(this.peer);
        if (this.peer.proto != self.proto || self.distHigh < this.peer.distLow || self.distLow > this.peer.distHigh) {
            this.close();
            throw new IOException("No common protocol found - cannot accept connection");
        }
        this.peer.distChoose = this.peer.distHigh > self.distHigh ? self.distHigh : this.peer.distHigh;
        this.doAccept();
        this.name = this.peer.node();
    }

    protected AbstractConnection(OtpLocalNode self, OtpPeer other) throws IOException, OtpAuthException {
        this.peer = other;
        this.self = self;
        this.socket = null;
        this.traceLevel = defaultLevel;
        this.setDaemon(true);
        int port = OtpEpmd.lookupPort(this.peer);
        if (this.peer.proto != self.proto || self.distHigh < this.peer.distLow || self.distLow > this.peer.distHigh) {
            throw new IOException("No common protocol found - cannot connect");
        }
        this.peer.distChoose = this.peer.distHigh > self.distHigh ? self.distHigh : this.peer.distHigh;
        this.doConnect(port);
        this.name = this.peer.node();
        this.connected = true;
    }

    public abstract void deliver(Exception var1);

    public abstract void deliver(OtpMsg var1);

    protected void sendBuf(OtpErlangPid from, String dest, OtpOutputStream payload) throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        OtpOutputStream header = new OtpOutputStream(2048);
        header.write4BE(0L);
        header.write1(112L);
        header.write1(-125L);
        header.write_tuple_head(4);
        header.write_long(6L);
        header.write_any(from);
        if (this.sendCookie) {
            header.write_atom(this.self.cookie());
        } else {
            header.write_atom("");
        }
        header.write_atom(dest);
        header.write1(-125L);
        header.poke4BE(0, header.size() + payload.size() - 4);
        this.do_send(header, payload);
    }

    protected void sendBuf(OtpErlangPid from, OtpErlangPid dest, OtpOutputStream payload) throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        OtpOutputStream header = new OtpOutputStream(2048);
        header.write4BE(0L);
        header.write1(112L);
        header.write1(-125L);
        header.write_tuple_head(3);
        header.write_long(2L);
        if (this.sendCookie) {
            header.write_atom(this.self.cookie());
        } else {
            header.write_atom("");
        }
        header.write_any(dest);
        header.write1(-125L);
        header.poke4BE(0, header.size() + payload.size() - 4);
        this.do_send(header, payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cookieError(OtpLocalNode local, OtpErlangAtom cookie) throws OtpAuthException {
        try {
            OtpOutputStream header = new OtpOutputStream(2048);
            header.write4BE(0L);
            header.write1(112L);
            header.write1(-125L);
            header.write_tuple_head(4);
            header.write_long(6L);
            header.write_any(local.createPid());
            header.write_atom(cookie.atomValue());
            header.write_atom("auth");
            header.write1(-125L);
            OtpErlangObject[] msg = new OtpErlangObject[2];
            OtpErlangObject[] msgbody = new OtpErlangObject[]{new OtpErlangAtom("print"), new OtpErlangString("~n** Bad cookie sent to " + local + " **~n"), new OtpErlangList()};
            msg[0] = new OtpErlangAtom("$gen_cast");
            msg[1] = new OtpErlangTuple(msgbody);
            OtpOutputStream payload = new OtpOutputStream(new OtpErlangTuple(msg));
            header.poke4BE(0, header.size() + payload.size() - 4);
            try {
                this.do_send(header, payload);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        finally {
            this.close();
        }
        throw new OtpAuthException("Remote cookie not authorized: " + cookie.atomValue());
    }

    protected void sendLink(OtpErlangPid from, OtpErlangPid dest) throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        OtpOutputStream header = new OtpOutputStream(2048);
        header.write4BE(0L);
        header.write1(112L);
        header.write1(-125L);
        header.write_tuple_head(3);
        header.write_long(1L);
        header.write_any(from);
        header.write_any(dest);
        header.poke4BE(0, header.size() - 4);
        this.do_send(header);
    }

    protected void sendUnlink(OtpErlangPid from, OtpErlangPid dest) throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        OtpOutputStream header = new OtpOutputStream(2048);
        header.write4BE(0L);
        header.write1(112L);
        header.write1(-125L);
        header.write_tuple_head(3);
        header.write_long(4L);
        header.write_any(from);
        header.write_any(dest);
        header.poke4BE(0, header.size() - 4);
        this.do_send(header);
    }

    protected void sendExit(OtpErlangPid from, OtpErlangPid dest, OtpErlangObject reason) throws IOException {
        this.sendExit(3, from, dest, reason);
    }

    protected void sendExit2(OtpErlangPid from, OtpErlangPid dest, OtpErlangObject reason) throws IOException {
        this.sendExit(8, from, dest, reason);
    }

    private void sendExit(int tag, OtpErlangPid from, OtpErlangPid dest, OtpErlangObject reason) throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        OtpOutputStream header = new OtpOutputStream(2048);
        header.write4BE(0L);
        header.write1(112L);
        header.write1(-125L);
        header.write_tuple_head(4);
        header.write_long(tag);
        header.write_any(from);
        header.write_any(dest);
        header.write_any(reason);
        header.poke4BE(0, header.size() - 4);
        this.do_send(header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (!this.connected) {
            this.deliver(new IOException("Not connected"));
            return;
        }
        byte[] lbuf = new byte[4];
        byte[] tock = new byte[]{0, 0, 0, 0};
        try {
            block19: while (!this.done) {
                OtpInputStream ibuf;
                int len;
                do {
                    this.readSock(this.socket, lbuf);
                    ibuf = new OtpInputStream(lbuf, this.flags);
                    len = ibuf.read4BE();
                    if (len != 0) continue;
                    AbstractConnection abstractConnection = this;
                    synchronized (abstractConnection) {
                        this.socket.getOutputStream().write(tock);
                    }
                } while (len == 0);
                byte[] tmpbuf = new byte[len];
                this.readSock(this.socket, tmpbuf);
                ibuf = new OtpInputStream(tmpbuf, this.flags);
                if (ibuf.read1() != 112) break;
                OtpErlangObject reason = null;
                OtpErlangAtom cookie = null;
                OtpErlangObject tmp = null;
                OtpErlangTuple head = null;
                tmp = ibuf.read_any();
                if (!(tmp instanceof OtpErlangTuple) || !((head = (OtpErlangTuple)tmp).elementAt(0) instanceof OtpErlangLong)) break;
                int tag = (int)((OtpErlangLong)head.elementAt(0)).longValue();
                switch (tag) {
                    case 2: 
                    case 12: {
                        OtpErlangObject traceobj;
                        if (!this.cookieOk) {
                            if (!(head.elementAt(1) instanceof OtpErlangAtom)) break block19;
                            cookie = (OtpErlangAtom)head.elementAt(1);
                            if (this.sendCookie) {
                                if (!cookie.atomValue().equals(this.self.cookie())) {
                                    this.cookieError(this.self, cookie);
                                }
                            } else if (!cookie.atomValue().equals("")) {
                                this.cookieError(this.self, cookie);
                            }
                            this.cookieOk = true;
                        }
                        if (this.traceLevel >= sendThreshold) {
                            System.out.println("<- " + this.headerType(head) + " " + head);
                            ibuf.mark(0);
                            traceobj = ibuf.read_any();
                            if (traceobj != null) {
                                System.out.println("   " + traceobj);
                            } else {
                                System.out.println("   (null)");
                            }
                            ibuf.reset();
                        }
                        OtpErlangPid to = (OtpErlangPid)head.elementAt(2);
                        this.deliver(new OtpMsg(to, ibuf));
                        continue block19;
                    }
                    case 6: 
                    case 16: {
                        OtpErlangObject traceobj;
                        if (!this.cookieOk) {
                            if (!(head.elementAt(2) instanceof OtpErlangAtom)) break block19;
                            cookie = (OtpErlangAtom)head.elementAt(2);
                            if (this.sendCookie) {
                                if (!cookie.atomValue().equals(this.self.cookie())) {
                                    this.cookieError(this.self, cookie);
                                }
                            } else if (!cookie.atomValue().equals("")) {
                                this.cookieError(this.self, cookie);
                            }
                            this.cookieOk = true;
                        }
                        if (this.traceLevel >= sendThreshold) {
                            System.out.println("<- " + this.headerType(head) + " " + head);
                            ibuf.mark(0);
                            traceobj = ibuf.read_any();
                            if (traceobj != null) {
                                System.out.println("   " + traceobj);
                            } else {
                                System.out.println("   (null)");
                            }
                            ibuf.reset();
                        }
                        OtpErlangPid from = (OtpErlangPid)head.elementAt(1);
                        OtpErlangAtom toName = (OtpErlangAtom)head.elementAt(3);
                        this.deliver(new OtpMsg(from, toName.atomValue(), ibuf));
                        continue block19;
                    }
                    case 3: 
                    case 8: {
                        if (head.elementAt(3) == null) break block19;
                        if (this.traceLevel >= ctrlThreshold) {
                            System.out.println("<- " + this.headerType(head) + " " + head);
                        }
                        OtpErlangPid from = (OtpErlangPid)head.elementAt(1);
                        OtpErlangPid to = (OtpErlangPid)head.elementAt(2);
                        reason = head.elementAt(3);
                        this.deliver(new OtpMsg(tag, from, to, reason));
                        continue block19;
                    }
                    case 13: 
                    case 18: {
                        if (head.elementAt(4) == null) break block19;
                        if (this.traceLevel >= ctrlThreshold) {
                            System.out.println("<- " + this.headerType(head) + " " + head);
                        }
                        OtpErlangPid from = (OtpErlangPid)head.elementAt(1);
                        OtpErlangPid to = (OtpErlangPid)head.elementAt(2);
                        reason = head.elementAt(4);
                        this.deliver(new OtpMsg(tag, from, to, reason));
                        continue block19;
                    }
                    case 1: 
                    case 4: {
                        if (this.traceLevel >= ctrlThreshold) {
                            System.out.println("<- " + this.headerType(head) + " " + head);
                        }
                        OtpErlangPid from = (OtpErlangPid)head.elementAt(1);
                        OtpErlangPid to = (OtpErlangPid)head.elementAt(2);
                        this.deliver(new OtpMsg(tag, from, to));
                        continue block19;
                    }
                    case 5: 
                    case 7: {
                        if (this.traceLevel < ctrlThreshold) continue block19;
                        System.out.println("<- " + this.headerType(head) + " " + head);
                        continue block19;
                    }
                }
            }
            this.deliver(new OtpErlangExit("Remote is sending garbage"));
            return;
        }
        catch (OtpAuthException e) {
            this.deliver(e);
            return;
        }
        catch (OtpErlangDecodeException e) {
            this.deliver(new OtpErlangExit("Remote is sending garbage"));
            return;
        }
        catch (IOException e) {
            this.deliver(new OtpErlangExit("Remote has closed connection"));
            return;
        }
        finally {
            this.close();
        }
    }

    public int setTraceLevel(int level) {
        int oldLevel = this.traceLevel;
        if (level < 0) {
            level = 0;
        } else if (level > 4) {
            level = 4;
        }
        this.traceLevel = level;
        return oldLevel;
    }

    public int getTraceLevel() {
        return this.traceLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.done = true;
        this.connected = false;
        AbstractConnection abstractConnection = this;
        synchronized (abstractConnection) {
            try {
                if (this.socket != null) {
                    if (this.traceLevel >= ctrlThreshold) {
                        System.out.println("-> CLOSE");
                    }
                    this.socket.close();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.socket = null;
            }
        }
    }

    protected void finalize() {
        this.close();
    }

    public boolean isConnected() {
        return this.connected;
    }

    protected synchronized void do_send(OtpOutputStream header, OtpOutputStream payload) throws IOException {
        try {
            if (this.traceLevel >= sendThreshold) {
                try {
                    OtpErlangObject h = header.getOtpInputStream(5).read_any();
                    System.out.println("-> " + this.headerType(h) + " " + h);
                    OtpErlangObject o = payload.getOtpInputStream(0).read_any();
                    System.out.println("   " + o);
                    o = null;
                }
                catch (OtpErlangDecodeException e) {
                    System.out.println("   can't decode output buffer:" + e);
                }
            }
            header.writeTo(this.socket.getOutputStream());
            payload.writeTo(this.socket.getOutputStream());
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    protected synchronized void do_send(OtpOutputStream header) throws IOException {
        try {
            if (this.traceLevel >= ctrlThreshold) {
                try {
                    OtpErlangObject h = header.getOtpInputStream(5).read_any();
                    System.out.println("-> " + this.headerType(h) + " " + h);
                }
                catch (OtpErlangDecodeException e) {
                    System.out.println("   can't decode output buffer: " + e);
                }
            }
            header.writeTo(this.socket.getOutputStream());
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    protected String headerType(OtpErlangObject h) {
        int tag = -1;
        if (h instanceof OtpErlangTuple) {
            tag = (int)((OtpErlangLong)((OtpErlangTuple)h).elementAt(0)).longValue();
        }
        switch (tag) {
            case 1: {
                return "LINK";
            }
            case 2: {
                return "SEND";
            }
            case 3: {
                return "EXIT";
            }
            case 4: {
                return "UNLINK";
            }
            case 5: {
                return "NODELINK";
            }
            case 6: {
                return "REG_SEND";
            }
            case 7: {
                return "GROUP_LEADER";
            }
            case 8: {
                return "EXIT2";
            }
            case 12: {
                return "SEND_TT";
            }
            case 13: {
                return "EXIT_TT";
            }
            case 16: {
                return "REG_SEND_TT";
            }
            case 18: {
                return "EXIT2_TT";
            }
        }
        return "(unknown type)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int readSock(Socket s, byte[] b) throws IOException {
        int got;
        int i;
        int len = b.length;
        InputStream is = null;
        AbstractConnection abstractConnection = this;
        synchronized (abstractConnection) {
            if (s == null) {
                throw new IOException("expected " + len + " bytes, socket was closed");
            }
            is = s.getInputStream();
        }
        for (got = 0; got < len; got += i) {
            i = is.read(b, got, len - got);
            if (i < 0) {
                throw new IOException("expected " + len + " bytes, got EOF after " + got + " bytes");
            }
            if (i != 0 || len == 0) continue;
            throw new IOException("Remote connection closed");
        }
        return got;
    }

    protected void doAccept() throws IOException, OtpAuthException {
        try {
            this.sendStatus("ok");
            int our_challenge = AbstractConnection.genChallenge();
            this.sendChallenge(this.peer.distChoose, this.self.flags, our_challenge);
            int her_challenge = this.recvChallengeReply(our_challenge);
            byte[] our_digest = this.genDigest(her_challenge, this.self.cookie());
            this.sendChallengeAck(our_digest);
            this.connected = true;
            this.cookieOk = true;
            this.sendCookie = false;
        }
        catch (IOException ie) {
            this.close();
            throw ie;
        }
        catch (OtpAuthException ae) {
            this.close();
            throw ae;
        }
        catch (Exception e) {
            String nn = this.peer.node();
            this.close();
            throw new IOException("Error accepting connection from " + nn);
        }
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("<- MD5 ACCEPTED " + this.peer.host());
        }
    }

    protected void doConnect(int port) throws IOException, OtpAuthException {
        try {
            this.socket = new Socket(this.peer.host(), port);
            this.socket.setTcpNoDelay(true);
            if (this.traceLevel >= handshakeThreshold) {
                System.out.println("-> MD5 CONNECT TO " + this.peer.host() + ":" + port);
            }
            this.sendName(this.peer.distChoose, this.self.flags);
            this.recvStatus();
            int her_challenge = this.recvChallenge();
            byte[] our_digest = this.genDigest(her_challenge, this.self.cookie());
            int our_challenge = AbstractConnection.genChallenge();
            this.sendChallengeReply(our_challenge, our_digest);
            this.recvChallengeAck(our_challenge);
            this.cookieOk = true;
            this.sendCookie = false;
        }
        catch (OtpAuthException ae) {
            this.close();
            throw ae;
        }
        catch (Exception e) {
            this.close();
            throw new IOException("Cannot connect to peer node");
        }
    }

    protected static int genChallenge() {
        return random.nextInt();
    }

    static String hex0(byte x) {
        int uint;
        char[] tab = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        if (x < 0) {
            uint = x & 0x7F;
            uint |= 0x80;
        } else {
            uint = x;
        }
        return "" + tab[uint >>> 4] + tab[uint & 0xF];
    }

    static String hex(byte[] b) {
        StringBuffer sb = new StringBuffer();
        try {
            for (int i = 0; i < b.length; ++i) {
                sb.append(AbstractConnection.hex0(b[i]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    protected byte[] genDigest(int challenge, String cookie) {
        long ch2;
        if (challenge < 0) {
            ch2 = 0x80000000L;
            ch2 |= (long)(challenge & Integer.MAX_VALUE);
        } else {
            ch2 = challenge;
        }
        OtpMD5 context = new OtpMD5();
        context.update(cookie);
        context.update("" + ch2);
        int[] tmp = context.final_bytes();
        byte[] res = new byte[tmp.length];
        for (int i = 0; i < tmp.length; ++i) {
            res[i] = (byte)(tmp[i] & 0xFF);
        }
        return res;
    }

    protected void sendName(int dist, int flags) throws IOException {
        OtpOutputStream obuf = new OtpOutputStream();
        String str = this.self.node();
        obuf.write2BE(str.length() + 7);
        obuf.write1(110L);
        obuf.write2BE(dist);
        obuf.write4BE(flags);
        obuf.write(str.getBytes());
        obuf.writeTo(this.socket.getOutputStream());
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("-> HANDSHAKE sendName flags=" + flags + " dist=" + dist + " local=" + this.self);
        }
    }

    protected void sendChallenge(int dist, int flags, int challenge) throws IOException {
        OtpOutputStream obuf = new OtpOutputStream();
        String str = this.self.node();
        obuf.write2BE(str.length() + 11);
        obuf.write1(110L);
        obuf.write2BE(dist);
        obuf.write4BE(flags);
        obuf.write4BE(challenge);
        obuf.write(str.getBytes());
        obuf.writeTo(this.socket.getOutputStream());
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("-> HANDSHAKE sendChallenge flags=" + flags + " dist=" + dist + " challenge=" + challenge + " local=" + this.self);
        }
    }

    protected byte[] read2BytePackage() throws IOException, OtpErlangDecodeException {
        byte[] lbuf = new byte[2];
        this.readSock(this.socket, lbuf);
        OtpInputStream ibuf = new OtpInputStream(lbuf, 0);
        int len = ibuf.read2BE();
        byte[] tmpbuf = new byte[len];
        this.readSock(this.socket, tmpbuf);
        return tmpbuf;
    }

    protected void recvName(OtpPeer peer) throws IOException {
        String hisname = "";
        try {
            byte[] tmpbuf = this.read2BytePackage();
            OtpInputStream ibuf = new OtpInputStream(tmpbuf, 0);
            int len = tmpbuf.length;
            peer.ntype = ibuf.read1();
            if (peer.ntype != 110) {
                throw new IOException("Unknown remote node type");
            }
            peer.distLow = peer.distHigh = ibuf.read2BE();
            if (peer.distLow < 5) {
                throw new IOException("Unknown remote node type");
            }
            peer.flags = ibuf.read4BE();
            byte[] tmpname = new byte[len - 7];
            ibuf.readN(tmpname);
            hisname = OtpErlangString.newString(tmpname);
            peer.ntype = (peer.flags & 1) != 0 ? 109 : 104;
            if ((peer.flags & 4) == 0) {
                throw new IOException("Handshake failed - peer cannot handle extended references");
            }
            if ((peer.flags & 0x100) == 0) {
                throw new IOException("Handshake failed - peer cannot handle extended pids and ports");
            }
        }
        catch (OtpErlangDecodeException e) {
            throw new IOException("Handshake failed - not enough data");
        }
        int i = hisname.indexOf(64, 0);
        peer.node = hisname;
        peer.alive = hisname.substring(0, i);
        peer.host = hisname.substring(i + 1, hisname.length());
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("<- HANDSHAKE ntype=" + peer.ntype + " dist=" + peer.distHigh + " remote=" + peer);
        }
    }

    protected int recvChallenge() throws IOException {
        int challenge;
        try {
            byte[] buf = this.read2BytePackage();
            OtpInputStream ibuf = new OtpInputStream(buf, 0);
            this.peer.ntype = ibuf.read1();
            if (this.peer.ntype != 110) {
                throw new IOException("Unexpected peer type");
            }
            this.peer.distLow = this.peer.distHigh = ibuf.read2BE();
            this.peer.flags = ibuf.read4BE();
            challenge = ibuf.read4BE();
            byte[] tmpname = new byte[buf.length - 11];
            ibuf.readN(tmpname);
            String hisname = OtpErlangString.newString(tmpname);
            if (!hisname.equals(this.peer.node)) {
                throw new IOException("Handshake failed - peer has wrong name: " + hisname);
            }
            if ((this.peer.flags & 4) == 0) {
                throw new IOException("Handshake failed - peer cannot handle extended references");
            }
            if ((this.peer.flags & 0x100) == 0) {
                throw new IOException("Handshake failed - peer cannot handle extended pids and ports");
            }
        }
        catch (OtpErlangDecodeException e) {
            throw new IOException("Handshake failed - not enough data");
        }
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("<- HANDSHAKE recvChallenge from=" + this.peer.node + " challenge=" + challenge + " local=" + this.self);
        }
        return challenge;
    }

    protected void sendChallengeReply(int challenge, byte[] digest) throws IOException {
        OtpOutputStream obuf = new OtpOutputStream();
        obuf.write2BE(21L);
        obuf.write1(114L);
        obuf.write4BE(challenge);
        obuf.write(digest);
        obuf.writeTo(this.socket.getOutputStream());
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("-> HANDSHAKE sendChallengeReply challenge=" + challenge + " digest=" + AbstractConnection.hex(digest) + " local=" + this.self);
        }
    }

    private boolean digests_equals(byte[] a, byte[] b) {
        for (int i = 0; i < 16; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    protected int recvChallengeReply(int our_challenge) throws IOException, OtpAuthException {
        int challenge;
        byte[] her_digest = new byte[16];
        try {
            byte[] buf = this.read2BytePackage();
            OtpInputStream ibuf = new OtpInputStream(buf, 0);
            int tag = ibuf.read1();
            if (tag != 114) {
                throw new IOException("Handshake protocol error");
            }
            challenge = ibuf.read4BE();
            ibuf.readN(her_digest);
            byte[] our_digest = this.genDigest(our_challenge, this.self.cookie());
            if (!this.digests_equals(her_digest, our_digest)) {
                throw new OtpAuthException("Peer authentication error.");
            }
        }
        catch (OtpErlangDecodeException e) {
            throw new IOException("Handshake failed - not enough data");
        }
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("<- HANDSHAKE recvChallengeReply from=" + this.peer.node + " challenge=" + challenge + " digest=" + AbstractConnection.hex(her_digest) + " local=" + this.self);
        }
        return challenge;
    }

    protected void sendChallengeAck(byte[] digest) throws IOException {
        OtpOutputStream obuf = new OtpOutputStream();
        obuf.write2BE(17L);
        obuf.write1(97L);
        obuf.write(digest);
        obuf.writeTo(this.socket.getOutputStream());
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("-> HANDSHAKE sendChallengeAck digest=" + AbstractConnection.hex(digest) + " local=" + this.self);
        }
    }

    protected void recvChallengeAck(int our_challenge) throws IOException, OtpAuthException {
        byte[] her_digest = new byte[16];
        try {
            byte[] buf = this.read2BytePackage();
            OtpInputStream ibuf = new OtpInputStream(buf, 0);
            int tag = ibuf.read1();
            if (tag != 97) {
                throw new IOException("Handshake protocol error");
            }
            ibuf.readN(her_digest);
            byte[] our_digest = this.genDigest(our_challenge, this.self.cookie());
            if (!this.digests_equals(her_digest, our_digest)) {
                throw new OtpAuthException("Peer authentication error.");
            }
        }
        catch (OtpErlangDecodeException e) {
            throw new IOException("Handshake failed - not enough data");
        }
        catch (Exception e) {
            throw new OtpAuthException("Peer authentication error.");
        }
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("<- HANDSHAKE recvChallengeAck from=" + this.peer.node + " digest=" + AbstractConnection.hex(her_digest) + " local=" + this.self);
        }
    }

    protected void sendStatus(String status) throws IOException {
        OtpOutputStream obuf = new OtpOutputStream();
        obuf.write2BE(status.length() + 1);
        obuf.write1(115L);
        obuf.write(status.getBytes());
        obuf.writeTo(this.socket.getOutputStream());
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("-> HANDSHAKE sendStatus status=" + status + " local=" + this.self);
        }
    }

    protected void recvStatus() throws IOException {
        try {
            byte[] buf = this.read2BytePackage();
            OtpInputStream ibuf = new OtpInputStream(buf, 0);
            int tag = ibuf.read1();
            if (tag != 115) {
                throw new IOException("Handshake protocol error");
            }
            byte[] tmpbuf = new byte[buf.length - 1];
            ibuf.readN(tmpbuf);
            String status = OtpErlangString.newString(tmpbuf);
            if (status.compareTo("ok") != 0) {
                throw new IOException("Peer replied with status '" + status + "' instead of 'ok'");
            }
        }
        catch (OtpErlangDecodeException e) {
            throw new IOException("Handshake failed - not enough data");
        }
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("<- HANDSHAKE recvStatus (ok) local=" + this.self);
        }
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public int getFlags() {
        return this.flags;
    }

    static {
        String trace = System.getProperties().getProperty("OtpConnection.trace");
        try {
            if (trace != null) {
                defaultLevel = Integer.valueOf(trace);
            }
        }
        catch (NumberFormatException e) {
            defaultLevel = 0;
        }
        random = new Random();
    }
}

