/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class AbstractNode {
    static String localHost = null;
    String node;
    String host;
    String alive;
    String cookie;
    static String defaultCookie = null;
    static final int NTYPE_R6 = 110;
    static final int NTYPE_R4_ERLANG = 109;
    static final int NTYPE_R4_HIDDEN = 104;
    static final int dFlagPublished = 1;
    static final int dFlagAtomCache = 2;
    static final int dFlagExtendedReferences = 4;
    static final int dFlagDistMonitor = 8;
    static final int dFlagFunTags = 16;
    static final int dFlagDistMonitorName = 32;
    static final int dFlagHiddenAtomCache = 64;
    static final int dflagNewFunTags = 128;
    static final int dFlagExtendedPidsPorts = 256;
    static final int dFlagExportPtrTag = 512;
    static final int dFlagBitBinaries = 1024;
    static final int dFlagNewFloats = 2048;
    int ntype = 110;
    int proto = 0;
    int distHigh = 5;
    int distLow = 5;
    int creation = 0;
    int flags = 3476;

    protected AbstractNode() {
    }

    protected AbstractNode(String node) {
        this(node, defaultCookie);
    }

    protected AbstractNode(String name, String cookie) {
        this.cookie = cookie;
        int i = name.indexOf(64, 0);
        if (i < 0) {
            this.alive = name;
            this.host = localHost;
        } else {
            this.alive = name.substring(0, i);
            this.host = name.substring(i + 1, name.length());
        }
        if (this.alive.length() > 255) {
            this.alive = this.alive.substring(0, 255);
        }
        this.node = this.alive + "@" + this.host;
    }

    public String node() {
        return this.node;
    }

    public String host() {
        return this.host;
    }

    public String alive() {
        return this.alive;
    }

    public String cookie() {
        return this.cookie;
    }

    int type() {
        return this.ntype;
    }

    int distHigh() {
        return this.distHigh;
    }

    int distLow() {
        return this.distLow;
    }

    int proto() {
        return this.proto;
    }

    int creation() {
        return this.creation;
    }

    public String setCookie(String cookie) {
        String prev = this.cookie;
        this.cookie = cookie;
        return prev;
    }

    public String toString() {
        return this.node();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            localHost = InetAddress.getLocalHost().getHostName();
            int dot = localHost.indexOf(".");
            if (dot != -1) {
                localHost = localHost.substring(0, dot);
            }
        }
        catch (UnknownHostException e) {
            localHost = "localhost";
        }
        String dotCookieFilename = System.getProperty("user.home") + File.separator + ".erlang.cookie";
        BufferedReader br = null;
        try {
            File dotCookieFile = new File(dotCookieFilename);
            br = new BufferedReader(new FileReader(dotCookieFile));
            defaultCookie = br.readLine().trim();
        }
        catch (IOException e) {
            defaultCookie = "";
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

