/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpOutputStream;
import java.io.Serializable;

public class OtpErlangAtom
extends OtpErlangObject
implements Serializable,
Cloneable {
    static final long serialVersionUID = -3204386396807876641L;
    public static final int maxAtomLength = 255;
    private final String atom;

    public OtpErlangAtom(String atom) {
        if (atom == null) {
            throw new IllegalArgumentException("null string value");
        }
        if (atom.length() > 255) {
            throw new IllegalArgumentException("Atom may not exceed 255 characters");
        }
        this.atom = atom;
    }

    public OtpErlangAtom(OtpInputStream buf) throws OtpErlangDecodeException {
        this.atom = buf.read_atom();
    }

    public OtpErlangAtom(boolean t) {
        this.atom = String.valueOf(t);
    }

    public String atomValue() {
        return this.atom;
    }

    public boolean booleanValue() {
        return Boolean.valueOf(this.atomValue());
    }

    public String toString() {
        if (this.atomNeedsQuoting(this.atom)) {
            return "'" + this.escapeSpecialChars(this.atom) + "'";
        }
        return this.atom;
    }

    public boolean equals(Object o) {
        if (!(o instanceof OtpErlangAtom)) {
            return false;
        }
        OtpErlangAtom atom = (OtpErlangAtom)o;
        return this.atom.compareTo(atom.atom) == 0;
    }

    protected int doHashCode() {
        return this.atom.hashCode();
    }

    public void encode(OtpOutputStream buf) {
        buf.write_atom(this.atom);
    }

    private boolean isErlangDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private boolean isErlangUpper(char c) {
        return c >= 'A' && c <= 'Z' || c == '_';
    }

    private boolean isErlangLower(char c) {
        return c >= 'a' && c <= 'z';
    }

    private boolean isErlangLetter(char c) {
        return this.isErlangLower(c) || this.isErlangUpper(c);
    }

    private boolean atomNeedsQuoting(String s) {
        if (s.length() == 0) {
            return true;
        }
        if (!this.isErlangLower(s.charAt(0))) {
            return true;
        }
        int len = s.length();
        for (int i = 1; i < len; ++i) {
            char c = s.charAt(i);
            if (this.isErlangLetter(c) || this.isErlangDigit(c) || c == '@') continue;
            return true;
        }
        return false;
    }

    private String escapeSpecialChars(String s) {
        StringBuffer so = new StringBuffer();
        int len = s.length();
        block13: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\b': {
                    so.append("\\b");
                    continue block13;
                }
                case '\u007f': {
                    so.append("\\d");
                    continue block13;
                }
                case '\u001b': {
                    so.append("\\e");
                    continue block13;
                }
                case '\f': {
                    so.append("\\f");
                    continue block13;
                }
                case '\n': {
                    so.append("\\n");
                    continue block13;
                }
                case '\r': {
                    so.append("\\r");
                    continue block13;
                }
                case '\t': {
                    so.append("\\t");
                    continue block13;
                }
                case '\u000b': {
                    so.append("\\v");
                    continue block13;
                }
                case '\\': {
                    so.append("\\\\");
                    continue block13;
                }
                case '\'': {
                    so.append("\\'");
                    continue block13;
                }
                case '\"': {
                    so.append("\\\"");
                    continue block13;
                }
                default: {
                    if (c < '\u0017') {
                        so.append("\\^" + (char)(64 + c));
                        continue block13;
                    }
                    if (c > '~') {
                        so.append("\\" + Integer.toOctalString(c));
                        continue block13;
                    }
                    so.append(c);
                }
            }
        }
        return new String(so);
    }
}

