/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpOutputStream;
import java.io.Serializable;

public class OtpErlangTuple
extends OtpErlangObject
implements Serializable,
Cloneable {
    static final long serialVersionUID = 9163498658004915935L;
    private static final OtpErlangObject[] NO_ELEMENTS = new OtpErlangObject[0];
    private OtpErlangObject[] elems = NO_ELEMENTS;

    public OtpErlangTuple(OtpErlangObject elem) {
        if (elem == null) {
            throw new IllegalArgumentException("Tuple element cannot be null");
        }
        this.elems = new OtpErlangObject[]{elem};
    }

    public OtpErlangTuple(OtpErlangObject[] elems) {
        this(elems, 0, elems.length);
    }

    public OtpErlangTuple(OtpErlangObject[] elems, int start, int count) {
        if (elems == null) {
            throw new IllegalArgumentException("Tuple content can't be null");
        }
        if (count < 1) {
            elems = NO_ELEMENTS;
        } else {
            this.elems = new OtpErlangObject[count];
            for (int i = 0; i < count; ++i) {
                if (elems[start + i] == null) {
                    throw new IllegalArgumentException("Tuple element cannot be null (element" + (start + i) + ")");
                }
                this.elems[i] = elems[start + i];
            }
        }
    }

    public OtpErlangTuple(OtpInputStream buf) throws OtpErlangDecodeException {
        int arity = buf.read_tuple_head();
        if (arity > 0) {
            this.elems = new OtpErlangObject[arity];
            for (int i = 0; i < arity; ++i) {
                this.elems[i] = buf.read_any();
            }
        } else {
            this.elems = NO_ELEMENTS;
        }
    }

    public int arity() {
        return this.elems.length;
    }

    public OtpErlangObject elementAt(int i) {
        if (i >= this.arity() || i < 0) {
            return null;
        }
        return this.elems[i];
    }

    public OtpErlangObject[] elements() {
        OtpErlangObject[] res = new OtpErlangObject[this.arity()];
        System.arraycopy(this.elems, 0, res, 0, res.length);
        return res;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        int arity = this.elems.length;
        s.append("{");
        for (int i = 0; i < arity; ++i) {
            if (i > 0) {
                s.append(",");
            }
            s.append(this.elems[i].toString());
        }
        s.append("}");
        return s.toString();
    }

    public void encode(OtpOutputStream buf) {
        int arity = this.elems.length;
        buf.write_tuple_head(arity);
        for (int i = 0; i < arity; ++i) {
            buf.write_any(this.elems[i]);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof OtpErlangTuple)) {
            return false;
        }
        OtpErlangTuple t = (OtpErlangTuple)o;
        int a = this.arity();
        if (a != t.arity()) {
            return false;
        }
        for (int i = 0; i < a; ++i) {
            if (this.elems[i].equals(t.elems[i])) continue;
            return false;
        }
        return true;
    }

    protected int doHashCode() {
        OtpErlangObject.Hash hash = new OtpErlangObject.Hash(9);
        int a = this.arity();
        hash.combine(a);
        for (int i = 0; i < a; ++i) {
            hash.combine(this.elems[i].hashCode());
        }
        return hash.valueOf();
    }

    public Object clone() {
        OtpErlangTuple newTuple = (OtpErlangTuple)super.clone();
        newTuple.elems = (OtpErlangObject[])this.elems.clone();
        return newTuple;
    }
}

