/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.util.collect;

import com.google.common.collect.ImmutableMap;
import java.util.Optional;
import org.ethelred.util.collect.TypedObjectKey;
import org.ethelred.util.collect.TypedObjectMap;

public class ImmutableTypedObjectMap
implements TypedObjectMap {
    private final ImmutableMap<TypedObjectKey<?>, Object> map;

    private ImmutableTypedObjectMap(ImmutableMap<TypedObjectKey<?>, Object> map) {
        this.map = map;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public <T> Optional<T> get(TypedObjectKey<T> key) {
        return Optional.ofNullable(this.map.get(key));
    }

    public static class Builder {
        private final ImmutableMap.Builder<TypedObjectKey<?>, Object> innerBuilder = ImmutableMap.builder();

        public <T> Builder put(TypedObjectKey<T> key, T value) {
            this.innerBuilder.put(key, value);
            return this;
        }

        public Builder set(TypedObjectKey<Boolean> flag) {
            return this.put(flag, true);
        }

        public ImmutableTypedObjectMap build() {
            return new ImmutableTypedObjectMap(this.innerBuilder.build());
        }
    }
}

