/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.util.console;

import java.io.IOException;
import java.util.Arrays;

public class ConsoleHelper {
    private static final ConsoleHelper INSTANCE = new ConsoleHelper();

    private ConsoleHelper() {
    }

    public static Key readKey() throws ConsoleKeyException {
        return INSTANCE._readKey();
    }

    private Key _readKey() throws ConsoleKeyException {
        try {
            this.rawMode();
            int input = System.in.read();
            int available = System.in.available();
            byte[] subs = new byte[]{};
            if (available > 0 && available < 6) {
                subs = new byte[available];
                System.in.read(subs);
            }
            Key key = Key.from(input, subs);
            return key;
        }
        catch (Exception e) {
            throw new ConsoleKeyException(e);
        }
        finally {
            this.cookedMode();
        }
    }

    private void cookedMode() {
        try {
            String[] cmd = new String[]{"/bin/sh", "-c", "stty cooked </dev/tty"};
            Runtime.getRuntime().exec(cmd).waitFor();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void rawMode() throws IOException, InterruptedException {
        String[] cmd = new String[]{"/bin/sh", "-c", "stty raw </dev/tty"};
        Runtime.getRuntime().exec(cmd).waitFor();
    }

    public static class ConsoleKeyException
    extends Exception {
        public ConsoleKeyException(Throwable cause) {
            super(cause);
        }
    }

    public static class Key {
        public static final Key CTRL_C = Key.from(3, new byte[0]);
        private final int input;
        private final byte[] subs;

        public Key(int input, byte[] subs) {
            this.input = input;
            this.subs = subs;
        }

        public char getChar() {
            return (char)this.input;
        }

        public boolean isChar() {
            if (this.subs.length > 0) {
                return false;
            }
            if (this.input == 13) {
                return true;
            }
            return this.input >= 32 && this.input <= 126;
        }

        private static Key from(int input, byte ... subs) {
            return new Key(input, subs);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Key{");
            sb.append("input=").append(this.input);
            sb.append(", subs=").append(Arrays.toString(this.subs));
            sb.append('}');
            return sb.toString();
        }
    }
}

