/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.util.console;

import com.sun.jna.Library;
import com.sun.jna.Native;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;

public class ConsoleUtil {
    private static final int ENOTTY = 25;
    private static Field filterOutputStreamInnerField = ConsoleUtil._lookupPrivateField(FilterOutputStream.class, "out");
    private static Field filterInputStreamInnerField = ConsoleUtil._lookupPrivateField(FilterInputStream.class, "in");
    private static Field fileDescriptorIntField = ConsoleUtil._lookupPrivateField(FileDescriptor.class, "fd");

    private ConsoleUtil() {
    }

    private static boolean _isATty(int fileDescriptor) throws TtyStateException {
        int result = CLibrary.INSTANCE.isatty(fileDescriptor);
        if (result == 1) {
            return true;
        }
        int errno = Native.getLastError();
        if (errno == 25) {
            return false;
        }
        throw new TtyStateException(fileDescriptor, errno);
    }

    public static boolean isATty(InputStream inputStream) throws IOException {
        return ConsoleUtil._isATty(ConsoleUtil._fileDescriptor(inputStream));
    }

    public static boolean isATty(OutputStream outputStream) throws IOException {
        return ConsoleUtil._isATty(ConsoleUtil._fileDescriptor(outputStream));
    }

    private static int _fileDescriptor(OutputStream outputStream) throws IOException {
        if (outputStream instanceof FileOutputStream) {
            return ConsoleUtil._fileDescriptor(((FileOutputStream)outputStream).getFD());
        }
        if (outputStream instanceof FilterOutputStream) {
            return ConsoleUtil._fileDescriptor(ConsoleUtil._unwrapFilterOutputStream((FilterOutputStream)outputStream));
        }
        throw new IOException("Cannot find file descriptor of " + outputStream);
    }

    private static OutputStream _unwrapFilterOutputStream(FilterOutputStream outputStream) throws IOException {
        try {
            return (OutputStream)filterOutputStreamInnerField.get(outputStream);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Could not access wrapped output stream", e);
        }
    }

    private static int _fileDescriptor(InputStream inputStream) throws IOException {
        if (inputStream instanceof FileInputStream) {
            return ConsoleUtil._fileDescriptor(((FileInputStream)inputStream).getFD());
        }
        if (inputStream instanceof FilterInputStream) {
            return ConsoleUtil._fileDescriptor(ConsoleUtil._unwrapFilterInputStream((FilterInputStream)inputStream));
        }
        throw new IOException("Cannot find file descriptor of " + inputStream);
    }

    private static InputStream _unwrapFilterInputStream(FilterInputStream inputStream) throws IOException {
        try {
            return (InputStream)filterInputStreamInnerField.get(inputStream);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Could not access wrapped input stream", e);
        }
    }

    private static Field _lookupPrivateField(Class<?> klass, String name) {
        Field field = null;
        try {
            field = klass.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        if (field != null) {
            field.setAccessible(true);
        }
        return field;
    }

    private static int _fileDescriptor(FileDescriptor fd) throws IOException {
        try {
            return (Integer)fileDescriptorIntField.get(fd);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Could not read file descriptor", e);
        }
    }

    private static class TtyStateException
    extends IOException {
        public TtyStateException(int fileDescriptor, int errno) {
            super("Unexpected tty result: fd=" + fileDescriptor + " errno=" + errno);
        }
    }

    static interface CLibrary
    extends Library {
        public static final CLibrary INSTANCE = (CLibrary)Native.loadLibrary((String)"c", CLibrary.class);

        public int isatty(int var1);
    }
}

