/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.util.console;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class TerminalColors {
    private final Map<String, String> m_cmdCache = new ConcurrentHashMap<String, String>();
    private final boolean m_enabled;
    private int m_supportedColors;
    @Nullable
    private String m_resetCmd;
    private OutputStream m_delegate;

    public TerminalColors() {
        this(System.out);
    }

    public TerminalColors(OutputStream delegate) {
        boolean enabled = false;
        try {
            String colorCountS = this._executeTputCmd("colors");
            this.m_supportedColors = Integer.parseInt(colorCountS.trim());
            if (this.m_supportedColors > 1) {
                enabled = true;
                this.m_resetCmd = this._executeTputCmd("sgr0");
            }
        }
        catch (IOException | NumberFormatException e) {
            System.err.print(e.getMessage());
            e.printStackTrace(System.err);
            enabled = false;
        }
        this.m_enabled = enabled;
        this.m_delegate = delegate;
    }

    private String _executeTputCmd(String cmd) throws IOException {
        String cached = this.m_cmdCache.get(cmd);
        if (cached != null) {
            return cached;
        }
        Process p = Runtime.getRuntime().exec(new String[]{"bash", "-c", "tput " + cmd});
        byte[] buf = new byte[1024];
        int read = p.getInputStream().read(buf);
        String result = new String(buf, 0, read);
        this.m_cmdCache.put(cmd, result);
        return result;
    }

    public TCPrintStream printStream() {
        return new TCPrintStream();
    }

    private int _firstValid(int colorNum, int[] backups) {
        if (!this.m_enabled) {
            return -1;
        }
        if (colorNum < this.m_supportedColors) {
            return colorNum;
        }
        for (int n : backups) {
            if (n >= this.m_supportedColors) continue;
            return n;
        }
        return -1;
    }

    public static void main(String[] args) {
        TerminalColors terminalColors = new TerminalColors();
        if (terminalColors.m_enabled) {
            for (int i = 0; i < terminalColors.m_supportedColors; ++i) {
                terminalColors.printStream().foreground(i, new int[0]).print(" " + i);
            }
            terminalColors.printStream().println();
        } else {
            System.out.println("Not enabled.");
        }
    }

    public class TCPrintStream
    extends PrintStream {
        String m_setupCmds;

        private TCPrintStream() {
            super(TerminalColors.this.m_delegate);
            this.m_setupCmds = "";
        }

        public TCPrintStream foreground(int colorNum, int ... backups) {
            if (!TerminalColors.this.m_enabled) {
                return this;
            }
            int color = TerminalColors.this._firstValid(colorNum, backups);
            if (color >= 0) {
                try {
                    this.m_setupCmds = this.m_setupCmds + TerminalColors.this._executeTputCmd("setaf " + color);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return this;
        }

        public TCPrintStream background(int colorNum, int ... backups) {
            if (!TerminalColors.this.m_enabled) {
                return this;
            }
            int color = TerminalColors.this._firstValid(colorNum, backups);
            if (color >= 0) {
                try {
                    this.m_setupCmds = this.m_setupCmds + TerminalColors.this._executeTputCmd("setab " + color);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return this;
        }

        public TCPrintStream bold() {
            if (!TerminalColors.this.m_enabled) {
                return this;
            }
            try {
                this.m_setupCmds = this.m_setupCmds + TerminalColors.this._executeTputCmd("bold");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this;
        }

        public TCPrintStream underline() {
            if (!TerminalColors.this.m_enabled) {
                return this;
            }
            try {
                this.m_setupCmds = this.m_setupCmds + TerminalColors.this._executeTputCmd("smul");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this;
        }

        private void _printSetup() {
            if (TerminalColors.this.m_enabled) {
                super.print(this.m_setupCmds);
            }
        }

        private void _printReset() {
            if (TerminalColors.this.m_enabled) {
                super.print(TerminalColors.this.m_resetCmd);
            }
        }

        private String _wrapFormat(String format) {
            if (TerminalColors.this.m_enabled) {
                return this.m_setupCmds + format + TerminalColors.this.m_resetCmd;
            }
            return format;
        }

        @Override
        public void print(boolean b) {
            this._printSetup();
            super.print(b);
            this._printReset();
        }

        @Override
        public void print(char c) {
            this._printSetup();
            super.print(c);
            this._printReset();
        }

        @Override
        public void print(int i) {
            this._printSetup();
            super.print(i);
            this._printReset();
        }

        @Override
        public void print(long l) {
            this._printSetup();
            super.print(l);
            this._printReset();
        }

        @Override
        public void print(float f) {
            this._printSetup();
            super.print(f);
            this._printReset();
        }

        @Override
        public void print(double d) {
            this._printSetup();
            super.print(d);
            this._printReset();
        }

        @Override
        public void print(char[] s) {
            this._printSetup();
            super.print(s);
            this._printReset();
        }

        @Override
        public void print(String s) {
            this._printSetup();
            super.print(s);
            this._printReset();
        }

        @Override
        public void print(Object obj) {
            this._printSetup();
            super.print(obj);
            this._printReset();
        }

        @Override
        public void println(boolean x) {
            this._printSetup();
            super.print(x);
            this._printReset();
            super.println();
        }

        @Override
        public void println(char x) {
            this._printSetup();
            super.print(x);
            this._printReset();
            super.println();
        }

        @Override
        public void println(int x) {
            this._printSetup();
            super.print(x);
            this._printReset();
            super.println();
        }

        @Override
        public void println(long x) {
            this._printSetup();
            super.print(x);
            this._printReset();
            super.println();
        }

        @Override
        public void println(float x) {
            this._printSetup();
            super.print(x);
            this._printReset();
            super.println();
        }

        @Override
        public void println(double x) {
            this._printSetup();
            super.print(x);
            this._printReset();
            super.println();
        }

        @Override
        public void println(char[] x) {
            this._printSetup();
            super.print(x);
            this._printReset();
            super.println();
        }

        @Override
        public void println(String x) {
            this._printSetup();
            super.print(x);
            this._printReset();
            super.println();
        }

        @Override
        public void println(Object x) {
            this._printSetup();
            super.print(x);
            this._printReset();
            super.println();
        }

        @Override
        public PrintStream format(String format, Object ... args) {
            return super.format(this._wrapFormat(format), args);
        }

        @Override
        public PrintStream format(Locale l, String format, Object ... args) {
            return super.format(l, this._wrapFormat(format), args);
        }
    }
}

