/*
 * Decompiled with CFR 0.152.
 */
package org.ethelred.util.stream;

import java.util.Comparator;
import java.util.stream.Collector;
import javax.annotation.CheckForNull;

public class SummaryStatistics<T> {
    private final Comparator<T> comparator;
    private int count;
    private T min;
    private T max;

    private SummaryStatistics(Comparator<T> comparator) {
        this.comparator = comparator;
    }

    public static <A extends Comparable<? super A>> Collector<A, ?, SummaryStatistics<A>> collector() {
        return SummaryStatistics.collector(Comparator.naturalOrder());
    }

    public static <B> Collector<B, ?, SummaryStatistics<B>> collector(Comparator<B> comparator) {
        return Collector.of(() -> new SummaryStatistics(comparator), SummaryStatistics::add, SummaryStatistics::combine, new Collector.Characteristics[0]);
    }

    private void add(T t) {
        ++this.count;
        this._min(t);
        this._max(t);
    }

    private void _max(T t) {
        if (this.max == null || this.comparator.compare(t, this.max) > 0) {
            this.max = t;
        }
    }

    private void _min(T t) {
        if (this.min == null || this.comparator.compare(t, this.min) < 0) {
            this.min = t;
        }
    }

    private SummaryStatistics<T> combine(SummaryStatistics<T> other) {
        this.count += other.count;
        this._min(other.min);
        this._max(other.max);
        return this;
    }

    @CheckForNull
    public T getMin() {
        return this.min;
    }

    @CheckForNull
    public T getMax() {
        return this.max;
    }

    public int getCount() {
        return this.count;
    }
}

