/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.geth;

import go.Seq;
import java.util.Arrays;
import org.ethereum.geth.Address;
import org.ethereum.geth.BigInt;
import org.ethereum.geth.Bloom;
import org.ethereum.geth.Geth;
import org.ethereum.geth.Hash;
import org.ethereum.geth.Header;
import org.ethereum.geth.Headers;
import org.ethereum.geth.Transaction;
import org.ethereum.geth.Transactions;

public final class Block
implements Seq.Proxy {
    private final int refnum;

    @Override
    public final int incRefnum() {
        Seq.incGoRef(this.refnum, this);
        return this.refnum;
    }

    public Block(String string) {
        this.refnum = Block.__NewBlockFromJSON(string);
        Seq.trackGoRef(this.refnum, this);
    }

    private static native int __NewBlockFromJSON(String var0);

    public Block(byte[] byArray) {
        this.refnum = Block.__NewBlockFromRLP(byArray);
        Seq.trackGoRef(this.refnum, this);
    }

    private static native int __NewBlockFromRLP(byte[] var0);

    Block(int n) {
        this.refnum = n;
        Seq.trackGoRef(n, this);
    }

    public native String encodeJSON() throws Exception;

    public native byte[] encodeRLP() throws Exception;

    public native Bloom getBloom();

    public native Address getCoinbase();

    public native BigInt getDifficulty();

    public native byte[] getExtra();

    public native long getGasLimit();

    public native long getGasUsed();

    public native Hash getHash();

    public native Hash getHashNoNonce();

    public native Header getHeader();

    public native Hash getMixDigest();

    public native long getNonce();

    public native long getNumber();

    public native Hash getParentHash();

    public native Hash getReceiptHash();

    public native Hash getRoot();

    public native long getTime();

    public native Transaction getTransaction(Hash var1);

    public native Transactions getTransactions();

    public native Hash getTxHash();

    public native Hash getUncleHash();

    public native Headers getUncles();

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Block)) {
            return false;
        }
        Block block = (Block)object;
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[0]);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Block").append("{");
        return stringBuilder.append("}").toString();
    }

    static {
        Geth.touch();
    }
}

