/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.geth;

import go.Seq;
import java.util.Arrays;
import org.ethereum.geth.Address;
import org.ethereum.geth.BigInt;
import org.ethereum.geth.Block;
import org.ethereum.geth.CallMsg;
import org.ethereum.geth.Context;
import org.ethereum.geth.FilterLogsHandler;
import org.ethereum.geth.FilterQuery;
import org.ethereum.geth.Geth;
import org.ethereum.geth.Hash;
import org.ethereum.geth.Header;
import org.ethereum.geth.Logs;
import org.ethereum.geth.NewHeadHandler;
import org.ethereum.geth.Receipt;
import org.ethereum.geth.Subscription;
import org.ethereum.geth.SyncProgress;
import org.ethereum.geth.Transaction;

public final class EthereumClient
implements Seq.Proxy {
    private final int refnum;

    @Override
    public final int incRefnum() {
        Seq.incGoRef(this.refnum, this);
        return this.refnum;
    }

    public EthereumClient(String string) {
        this.refnum = EthereumClient.__NewEthereumClient(string);
        Seq.trackGoRef(this.refnum, this);
    }

    private static native int __NewEthereumClient(String var0);

    EthereumClient(int n) {
        this.refnum = n;
        Seq.trackGoRef(n, this);
    }

    public native byte[] callContract(Context var1, CallMsg var2, long var3) throws Exception;

    public native long estimateGas(Context var1, CallMsg var2) throws Exception;

    public native Logs filterLogs(Context var1, FilterQuery var2) throws Exception;

    public native BigInt getBalanceAt(Context var1, Address var2, long var3) throws Exception;

    public native Block getBlockByHash(Context var1, Hash var2) throws Exception;

    public native Block getBlockByNumber(Context var1, long var2) throws Exception;

    public native byte[] getCodeAt(Context var1, Address var2, long var3) throws Exception;

    public native Header getHeaderByHash(Context var1, Hash var2) throws Exception;

    public native Header getHeaderByNumber(Context var1, long var2) throws Exception;

    public native long getNonceAt(Context var1, Address var2, long var3) throws Exception;

    public native BigInt getPendingBalanceAt(Context var1, Address var2) throws Exception;

    public native byte[] getPendingCodeAt(Context var1, Address var2) throws Exception;

    public native long getPendingNonceAt(Context var1, Address var2) throws Exception;

    public native byte[] getPendingStorageAt(Context var1, Address var2, Hash var3) throws Exception;

    public native long getPendingTransactionCount(Context var1) throws Exception;

    public native byte[] getStorageAt(Context var1, Address var2, Hash var3, long var4) throws Exception;

    public native Transaction getTransactionByHash(Context var1, Hash var2) throws Exception;

    public native long getTransactionCount(Context var1, Hash var2) throws Exception;

    public native Transaction getTransactionInBlock(Context var1, Hash var2, long var3) throws Exception;

    public native Receipt getTransactionReceipt(Context var1, Hash var2) throws Exception;

    public native Address getTransactionSender(Context var1, Transaction var2, Hash var3, long var4) throws Exception;

    public native byte[] pendingCallContract(Context var1, CallMsg var2) throws Exception;

    public native void sendTransaction(Context var1, Transaction var2) throws Exception;

    public native Subscription subscribeFilterLogs(Context var1, FilterQuery var2, FilterLogsHandler var3, long var4) throws Exception;

    public native Subscription subscribeNewHead(Context var1, NewHeadHandler var2, long var3) throws Exception;

    public native BigInt suggestGasPrice(Context var1) throws Exception;

    public native SyncProgress syncProgress(Context var1) throws Exception;

    public boolean equals(Object object) {
        if (object == null || !(object instanceof EthereumClient)) {
            return false;
        }
        EthereumClient ethereumClient = (EthereumClient)object;
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[0]);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("EthereumClient").append("{");
        return stringBuilder.append("}").toString();
    }

    static {
        Geth.touch();
    }
}

