/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.geth;

import go.Seq;
import org.ethereum.geth.Address;
import org.ethereum.geth.Addresses;
import org.ethereum.geth.BigInt;
import org.ethereum.geth.Block;
import org.ethereum.geth.BoundContract;
import org.ethereum.geth.CallMsg;
import org.ethereum.geth.CallOpts;
import org.ethereum.geth.Context;
import org.ethereum.geth.Enode;
import org.ethereum.geth.Enodes;
import org.ethereum.geth.EthereumClient;
import org.ethereum.geth.FilterLogsHandler;
import org.ethereum.geth.FilterQuery;
import org.ethereum.geth.Hash;
import org.ethereum.geth.Hashes;
import org.ethereum.geth.Header;
import org.ethereum.geth.Interface;
import org.ethereum.geth.Interfaces;
import org.ethereum.geth.KeyStore;
import org.ethereum.geth.Log;
import org.ethereum.geth.NewHeadHandler;
import org.ethereum.geth.Node;
import org.ethereum.geth.NodeConfig;
import org.ethereum.geth.Receipt;
import org.ethereum.geth.Signer;
import org.ethereum.geth.Topics;
import org.ethereum.geth.TransactOpts;
import org.ethereum.geth.Transaction;

public abstract class Geth {
    public static final long LightScryptN = 4096L;
    public static final long LightScryptP = 6L;
    public static final long StandardScryptN = 262144L;
    public static final long StandardScryptP = 1L;

    private Geth() {
    }

    public static void touch() {
    }

    private static native void _init();

    public static native BoundContract bindContract(Address var0, String var1, EthereumClient var2) throws Exception;

    public static native BoundContract deployContract(TransactOpts var0, String var1, byte[] var2, EthereumClient var3, Interfaces var4) throws Exception;

    public static native Enodes foundationBootnodes();

    public static native String mainnetGenesis();

    public static native Address newAddressFromBytes(byte[] var0) throws Exception;

    public static native Address newAddressFromHex(String var0) throws Exception;

    public static native Addresses newAddresses(long var0);

    public static native Addresses newAddressesEmpty();

    public static native BigInt newBigInt(long var0);

    public static native Block newBlockFromJSON(String var0) throws Exception;

    public static native Block newBlockFromRLP(byte[] var0) throws Exception;

    public static native CallMsg newCallMsg();

    public static native CallOpts newCallOpts();

    public static native Context newContext();

    public static native Enode newEnode(String var0) throws Exception;

    public static native Enodes newEnodes(long var0);

    public static native Enodes newEnodesEmpty();

    public static native EthereumClient newEthereumClient(String var0) throws Exception;

    public static native FilterQuery newFilterQuery();

    public static native Hash newHashFromBytes(byte[] var0) throws Exception;

    public static native Hash newHashFromHex(String var0) throws Exception;

    public static native Hashes newHashes(long var0);

    public static native Hashes newHashesEmpty();

    public static native Header newHeaderFromJSON(String var0) throws Exception;

    public static native Header newHeaderFromRLP(byte[] var0) throws Exception;

    public static native Interface newInterface();

    public static native Interfaces newInterfaces(long var0);

    public static native KeyStore newKeyStore(String var0, long var1, long var3);

    public static native Node newNode(String var0, NodeConfig var1) throws Exception;

    public static native NodeConfig newNodeConfig();

    public static native Receipt newReceiptFromJSON(String var0) throws Exception;

    public static native Receipt newReceiptFromRLP(byte[] var0) throws Exception;

    public static native Topics newTopics(long var0);

    public static native Topics newTopicsEmpty();

    public static native Transaction newTransaction(long var0, Address var2, BigInt var3, long var4, BigInt var6, byte[] var7);

    public static native Transaction newTransactionFromJSON(String var0) throws Exception;

    public static native Transaction newTransactionFromRLP(byte[] var0) throws Exception;

    public static native String rinkebyGenesis();

    public static native void setVerbosity(long var0);

    public static native String testnetGenesis();

    static {
        Seq.touch();
        Geth._init();
    }

    private static final class proxySigner
    implements Seq.Proxy,
    Signer {
        private final int refnum;

        @Override
        public final int incRefnum() {
            Seq.incGoRef(this.refnum, this);
            return this.refnum;
        }

        proxySigner(int n) {
            this.refnum = n;
            Seq.trackGoRef(n, this);
        }

        @Override
        public native Transaction sign(Address var1, Transaction var2) throws Exception;
    }

    private static final class proxyNewHeadHandler
    implements Seq.Proxy,
    NewHeadHandler {
        private final int refnum;

        @Override
        public final int incRefnum() {
            Seq.incGoRef(this.refnum, this);
            return this.refnum;
        }

        proxyNewHeadHandler(int n) {
            this.refnum = n;
            Seq.trackGoRef(n, this);
        }

        @Override
        public native void onError(String var1);

        @Override
        public native void onNewHead(Header var1);
    }

    private static final class proxyFilterLogsHandler
    implements Seq.Proxy,
    FilterLogsHandler {
        private final int refnum;

        @Override
        public final int incRefnum() {
            Seq.incGoRef(this.refnum, this);
            return this.refnum;
        }

        proxyFilterLogsHandler(int n) {
            this.refnum = n;
            Seq.trackGoRef(n, this);
        }

        @Override
        public native void onError(String var1);

        @Override
        public native void onFilterLogs(Log var1);
    }
}

