/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.geth;

import go.Seq;
import java.util.Arrays;
import org.ethereum.geth.Address;
import org.ethereum.geth.BigInt;
import org.ethereum.geth.Bloom;
import org.ethereum.geth.Geth;
import org.ethereum.geth.Hash;
import org.ethereum.geth.Nonce;

public final class Header
implements Seq.Proxy {
    private final int refnum;

    @Override
    public final int incRefnum() {
        Seq.incGoRef(this.refnum, this);
        return this.refnum;
    }

    public Header(String string) {
        this.refnum = Header.__NewHeaderFromJSON(string);
        Seq.trackGoRef(this.refnum, this);
    }

    private static native int __NewHeaderFromJSON(String var0);

    public Header(byte[] byArray) {
        this.refnum = Header.__NewHeaderFromRLP(byArray);
        Seq.trackGoRef(this.refnum, this);
    }

    private static native int __NewHeaderFromRLP(byte[] var0);

    Header(int n) {
        this.refnum = n;
        Seq.trackGoRef(n, this);
    }

    public native String encodeJSON() throws Exception;

    public native byte[] encodeRLP() throws Exception;

    public native Bloom getBloom();

    public native Address getCoinbase();

    public native BigInt getDifficulty();

    public native byte[] getExtra();

    public native long getGasLimit();

    public native long getGasUsed();

    public native Hash getHash();

    public native Hash getMixDigest();

    public native Nonce getNonce();

    public native long getNumber();

    public native Hash getParentHash();

    public native Hash getReceiptHash();

    public native Hash getRoot();

    public native long getTime();

    public native Hash getTxHash();

    public native Hash getUncleHash();

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Header)) {
            return false;
        }
        Header header = (Header)object;
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[0]);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Header").append("{");
        return stringBuilder.append("}").toString();
    }

    static {
        Geth.touch();
    }
}

