/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.geth;

import go.Seq;
import java.util.Arrays;
import org.ethereum.geth.Address;
import org.ethereum.geth.Bloom;
import org.ethereum.geth.Geth;
import org.ethereum.geth.Hash;
import org.ethereum.geth.Logs;

public final class Receipt
implements Seq.Proxy {
    private final int refnum;

    @Override
    public final int incRefnum() {
        Seq.incGoRef(this.refnum, this);
        return this.refnum;
    }

    public Receipt(String string) {
        this.refnum = Receipt.__NewReceiptFromJSON(string);
        Seq.trackGoRef(this.refnum, this);
    }

    private static native int __NewReceiptFromJSON(String var0);

    public Receipt(byte[] byArray) {
        this.refnum = Receipt.__NewReceiptFromRLP(byArray);
        Seq.trackGoRef(this.refnum, this);
    }

    private static native int __NewReceiptFromRLP(byte[] var0);

    Receipt(int n) {
        this.refnum = n;
        Seq.trackGoRef(n, this);
    }

    public native String encodeJSON() throws Exception;

    public native byte[] encodeRLP() throws Exception;

    public native Bloom getBloom();

    public native Address getContractAddress();

    public native long getCumulativeGasUsed();

    public native long getGasUsed();

    public native Logs getLogs();

    public native byte[] getPostState();

    public native long getStatus();

    public native Hash getTxHash();

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Receipt)) {
            return false;
        }
        Receipt receipt = (Receipt)object;
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[0]);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Receipt").append("{");
        return stringBuilder.append("}").toString();
    }

    static {
        Geth.touch();
    }
}

