/*
 * Decompiled with CFR 0.152.
 */
package org.ethereum.geth;

import go.Seq;
import java.util.Arrays;
import org.ethereum.geth.Address;
import org.ethereum.geth.BigInt;
import org.ethereum.geth.Geth;
import org.ethereum.geth.Hash;

public final class Transaction
implements Seq.Proxy {
    private final int refnum;

    @Override
    public final int incRefnum() {
        Seq.incGoRef(this.refnum, this);
        return this.refnum;
    }

    public Transaction(long l, Address address, BigInt bigInt, long l2, BigInt bigInt2, byte[] byArray) {
        this.refnum = Transaction.__NewTransaction(l, address, bigInt, l2, bigInt2, byArray);
        Seq.trackGoRef(this.refnum, this);
    }

    private static native int __NewTransaction(long var0, Address var2, BigInt var3, long var4, BigInt var6, byte[] var7);

    public Transaction(String string) {
        this.refnum = Transaction.__NewTransactionFromJSON(string);
        Seq.trackGoRef(this.refnum, this);
    }

    private static native int __NewTransactionFromJSON(String var0);

    public Transaction(byte[] byArray) {
        this.refnum = Transaction.__NewTransactionFromRLP(byArray);
        Seq.trackGoRef(this.refnum, this);
    }

    private static native int __NewTransactionFromRLP(byte[] var0);

    Transaction(int n) {
        this.refnum = n;
        Seq.trackGoRef(n, this);
    }

    public native String encodeJSON() throws Exception;

    public native byte[] encodeRLP() throws Exception;

    public native BigInt getCost();

    public native byte[] getData();

    public native Address getFrom(BigInt var1) throws Exception;

    public native long getGas();

    public native BigInt getGasPrice();

    public native Hash getHash();

    public native long getNonce();

    public native Hash getSigHash();

    public native Address getTo();

    public native BigInt getValue();

    public native Transaction withSignature(byte[] var1, BigInt var2) throws Exception;

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Transaction)) {
            return false;
        }
        Transaction transaction = (Transaction)object;
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[0]);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Transaction").append("{");
        return stringBuilder.append("}").toString();
    }

    static {
        Geth.touch();
    }
}

