/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.Arrays;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONObject;

public final class ObjectComparator {
    public static boolean deepEquals(Object obj1, Object obj2) {
        if (obj1 instanceof JSONArray) {
            if (!(obj2 instanceof JSONArray)) {
                return false;
            }
            return ObjectComparator.deepEqualArrays((JSONArray)obj1, (JSONArray)obj2);
        }
        if (obj1 instanceof JSONObject) {
            if (!(obj2 instanceof JSONObject)) {
                return false;
            }
            return ObjectComparator.deepEqualObjects((JSONObject)obj1, (JSONObject)obj2);
        }
        return Objects.equals(obj1, obj2);
    }

    private static boolean deepEqualArrays(JSONArray arr1, JSONArray arr2) {
        if (arr1.length() != arr2.length()) {
            return false;
        }
        for (int i = 0; i < arr1.length(); ++i) {
            if (ObjectComparator.deepEquals(arr1.get(i), arr2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean deepEqualObjects(JSONObject jsonObj1, JSONObject jsonObj2) {
        Object[] obj1Names = JSONObject.getNames((JSONObject)jsonObj1);
        if (!Arrays.equals(obj1Names, JSONObject.getNames((JSONObject)jsonObj2))) {
            return false;
        }
        if (obj1Names == null) {
            return true;
        }
        for (Object name : obj1Names) {
            if (ObjectComparator.deepEquals(jsonObj1.get((String)name), jsonObj2.get((String)name))) continue;
            return false;
        }
        return true;
    }

    private ObjectComparator() {
    }
}

