/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.BooleanSchema;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.EmptySchema;
import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.NotSchema;
import org.everit.json.schema.NullSchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.SchemaException;
import org.everit.json.schema.StringSchema;
import org.everit.json.schema.loader.SchemaClient;
import org.everit.json.schema.loader.internal.DefaultSchemaClient;
import org.everit.json.schema.loader.internal.JSONPointer;
import org.json.JSONArray;
import org.json.JSONObject;

public class SchemaLoader {
    private static final List<String> ARRAY_SCHEMA_PROPS = Arrays.asList("items", "additionalItems", "minItems", "maxItems", "uniqueItems");
    private static final List<String> OBJECT_SCHEMA_PROPS = Arrays.asList("properties", "required", "minProperties", "maxProperties", "dependencies", "patternProperties", "additionalProperties");
    private static final List<String> NUMBER_SCHEMA_PROPS = Arrays.asList("minimum", "maximum", "minimumExclusive", "maximumExclusive", "multipleOf");
    private static final List<String> STRING_SCHEMA_PROPS = Arrays.asList("minLength", "maxLength", "pattern");
    private static final Map<String, Function<Collection<Schema>, CombinedSchema.Builder>> COMBINED_SUBSCHEMA_PROVIDERS = new HashMap<String, Function<Collection<Schema>, CombinedSchema.Builder>>(3);
    private String id = null;
    private final JSONObject schemaJson;
    private final JSONObject rootSchemaJson;
    private final SchemaClient httpClient;
    private final Map<String, ReferenceSchema.Builder> pointerSchemas;

    public static Schema load(JSONObject schemaJson) {
        return SchemaLoader.load(schemaJson, new DefaultSchemaClient());
    }

    public static Schema load(JSONObject schemaJson, SchemaClient httpClient) {
        String schemaId = schemaJson.optString("id");
        return new SchemaLoader(schemaId, schemaJson, schemaJson, new HashMap<String, ReferenceSchema.Builder>(), httpClient).load().build();
    }

    SchemaLoader(String id, JSONObject schemaJson, JSONObject rootSchemaJson, Map<String, ReferenceSchema.Builder> pointerSchemas, SchemaClient httpClient) {
        this.schemaJson = Objects.requireNonNull(schemaJson, "schemaJson cannot be null");
        this.rootSchemaJson = Objects.requireNonNull(rootSchemaJson, "rootSchemaJson cannot be null");
        this.id = id;
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient cannot be null");
        this.pointerSchemas = pointerSchemas;
    }

    private void addDependencies(ObjectSchema.Builder builder, JSONObject deps) {
        Arrays.stream(JSONObject.getNames((JSONObject)deps)).forEach(ifPresent -> this.addDependency(builder, (String)ifPresent, deps.get(ifPresent)));
    }

    private void addDependency(ObjectSchema.Builder builder, String ifPresent, Object deps) {
        this.typeMultiplexer(deps).ifObject().then(obj -> builder.schemaDependency(ifPresent, (Schema)this.loadChild((JSONObject)obj).build())).ifIs(JSONArray.class).then(propNames -> IntStream.range(0, propNames.length()).mapToObj(i -> propNames.getString(i)).forEach(dependency -> builder.propertyDependency(ifPresent, (String)dependency))).requireAny();
    }

    private CombinedSchema.Builder buildAnyOfSchemaForMultipleTypes() {
        JSONArray subtypeJsons = this.schemaJson.getJSONArray("type");
        HashMap<String, Object> dummyJson = new HashMap<String, Object>();
        ArrayList<Schema> subschemas = new ArrayList<Schema>(subtypeJsons.length());
        for (int i = 0; i < subtypeJsons.length(); ++i) {
            Object subtypeJson = subtypeJsons.get(i);
            dummyJson.put("type", subtypeJson);
            JSONObject child = new JSONObject(dummyJson);
            subschemas.add((Schema)this.loadChild(child).build());
        }
        return CombinedSchema.anyOf(subschemas);
    }

    private ArraySchema.Builder buildArraySchema() {
        ArraySchema.Builder builder = ArraySchema.builder();
        this.ifPresent("minItems", Integer.class, builder::minItems);
        this.ifPresent("maxItems", Integer.class, builder::maxItems);
        this.ifPresent("uniqueItems", Boolean.class, builder::uniqueItems);
        if (this.schemaJson.has("additionalItems")) {
            this.typeMultiplexer("additionalItems", this.schemaJson.get("additionalItems")).ifIs(Boolean.class).then(builder::additionalItems).ifObject().then(jsonObj -> builder.schemaOfAdditionalItems((Schema)this.loadChild((JSONObject)jsonObj).build())).requireAny();
        }
        if (this.schemaJson.has("items")) {
            this.typeMultiplexer("items", this.schemaJson.get("items")).ifObject().then(itemSchema -> builder.allItemSchema((Schema)this.loadChild((JSONObject)itemSchema).build())).ifIs(JSONArray.class).then(arr -> this.buildTupleSchema(builder, (JSONArray)arr)).requireAny();
        }
        return builder;
    }

    private EnumSchema.Builder buildEnumSchema() {
        HashSet<Object> possibleValues = new HashSet<Object>();
        JSONArray arr = this.schemaJson.getJSONArray("enum");
        IntStream.range(0, arr.length()).mapToObj(arg_0 -> ((JSONArray)arr).get(arg_0)).forEach(possibleValues::add);
        return EnumSchema.builder().possibleValues(possibleValues);
    }

    private NotSchema.Builder buildNotSchema() {
        Object mustNotMatch = this.loadChild(this.schemaJson.getJSONObject("not")).build();
        return NotSchema.builder().mustNotMatch((Schema)mustNotMatch);
    }

    private NumberSchema.Builder buildNumberSchema() {
        NumberSchema.Builder builder = NumberSchema.builder();
        this.ifPresent("minimum", Number.class, builder::minimum);
        this.ifPresent("maximum", Number.class, builder::maximum);
        this.ifPresent("multipleOf", Number.class, builder::multipleOf);
        this.ifPresent("exclusiveMinimum", Boolean.class, builder::exclusiveMinimum);
        this.ifPresent("exclusiveMaximum", Boolean.class, builder::exclusiveMaximum);
        return builder;
    }

    private ObjectSchema.Builder buildObjectSchema() {
        JSONObject patternPropsJson;
        String[] patterns;
        ObjectSchema.Builder builder = ObjectSchema.builder();
        this.ifPresent("minProperties", Integer.class, builder::minProperties);
        this.ifPresent("maxProperties", Integer.class, builder::maxProperties);
        if (this.schemaJson.has("properties")) {
            JSONObject propertyDefs = this.schemaJson.getJSONObject("properties");
            Arrays.stream((Object[])Optional.ofNullable(JSONObject.getNames((JSONObject)propertyDefs)).orElse(new String[0])).forEach(key -> builder.addPropertySchema((String)key, (Schema)this.loadChild(propertyDefs.getJSONObject(key)).build()));
        }
        if (this.schemaJson.has("additionalProperties")) {
            this.typeMultiplexer("additionalProperties", this.schemaJson.get("additionalProperties")).ifIs(Boolean.class).then(builder::additionalProperties).ifObject().then(def -> builder.schemaOfAdditionalProperties((Schema)this.loadChild((JSONObject)def).build())).requireAny();
        }
        if (this.schemaJson.has("required")) {
            JSONArray requiredJson = this.schemaJson.getJSONArray("required");
            IntStream.range(0, requiredJson.length()).mapToObj(arg_0 -> ((JSONArray)requiredJson).getString(arg_0)).forEach(builder::addRequiredProperty);
        }
        if (this.schemaJson.has("patternProperties") && (patterns = JSONObject.getNames((JSONObject)(patternPropsJson = this.schemaJson.getJSONObject("patternProperties")))) != null) {
            for (String pattern : patterns) {
                builder.patternProperty(pattern, (Schema)this.loadChild(patternPropsJson.getJSONObject(pattern)).build());
            }
        }
        this.ifPresent("dependencies", JSONObject.class, deps -> this.addDependencies(builder, (JSONObject)deps));
        return builder;
    }

    private Schema.Builder<?> buildSchemaWithoutExplicitType() {
        if (this.schemaJson.length() == 0) {
            return EmptySchema.builder();
        }
        if (this.schemaJson.has("$ref")) {
            return this.lookupReference(this.schemaJson.getString("$ref"));
        }
        Schema.Builder<?> rval = this.sniffSchemaByProps();
        if (rval != null) {
            return rval;
        }
        if (this.schemaJson.has("not")) {
            return this.buildNotSchema();
        }
        return EmptySchema.builder();
    }

    private StringSchema.Builder buildStringSchema() {
        StringSchema.Builder builder = StringSchema.builder();
        this.ifPresent("minLength", Integer.class, builder::minLength);
        this.ifPresent("maxLength", Integer.class, builder::maxLength);
        this.ifPresent("pattern", String.class, builder::pattern);
        return builder;
    }

    private void buildTupleSchema(ArraySchema.Builder builder, JSONArray itemSchema) {
        for (int i = 0; i < itemSchema.length(); ++i) {
            this.typeMultiplexer(itemSchema.get(i)).ifObject().then(schema -> builder.addItemSchema((Schema)this.loadChild((JSONObject)schema).build())).requireAny();
        }
    }

    private <E> void ifPresent(String key, Class<E> expectedType, Consumer<E> consumer) {
        if (this.schemaJson.has(key)) {
            Object value = this.schemaJson.get(key);
            try {
                consumer.accept(value);
            }
            catch (ClassCastException e) {
                throw new SchemaException(key, expectedType, value);
            }
        }
    }

    private Schema.Builder<?> load() {
        Schema.Builder builder;
        if (this.schemaJson.has("enum")) {
            builder = this.buildEnumSchema();
        } else {
            builder = this.tryCombinedSchema();
            if (builder == null) {
                builder = !this.schemaJson.has("type") ? this.buildSchemaWithoutExplicitType() : this.loadForType(this.schemaJson.get("type"));
            }
        }
        this.ifPresent("id", String.class, builder::id);
        this.ifPresent("title", String.class, builder::title);
        this.ifPresent("description", String.class, builder::description);
        return builder;
    }

    private Schema.Builder<?> loadChild(JSONObject childJson) {
        return new SchemaLoader(this.id, childJson, this.rootSchemaJson, this.pointerSchemas, this.httpClient).load();
    }

    private Schema.Builder<?> loadForExplicitType(String typeString) {
        switch (typeString) {
            case "string": {
                return this.buildStringSchema();
            }
            case "integer": {
                return this.buildNumberSchema().requiresInteger(true);
            }
            case "number": {
                return this.buildNumberSchema();
            }
            case "boolean": {
                return BooleanSchema.builder();
            }
            case "null": {
                return NullSchema.builder();
            }
            case "array": {
                return this.buildArraySchema();
            }
            case "object": {
                return this.buildObjectSchema();
            }
        }
        throw new SchemaException(String.format("unknown type: [%s]", typeString));
    }

    private Schema.Builder<?> loadForType(Object type) {
        if (type instanceof JSONArray) {
            return this.buildAnyOfSchemaForMultipleTypes();
        }
        if (type instanceof String) {
            return this.loadForExplicitType((String)type);
        }
        throw new SchemaException("type", Arrays.asList(JSONArray.class, String.class), type);
    }

    private Schema.Builder<?> lookupReference(String relPointerString) {
        String absPointerString = this.id + relPointerString;
        if (this.pointerSchemas.containsKey(absPointerString)) {
            return this.pointerSchemas.get(absPointerString);
        }
        JSONPointer pointer = absPointerString.startsWith("#") ? JSONPointer.forDocument(this.rootSchemaJson, absPointerString) : JSONPointer.forURL(this.httpClient, absPointerString);
        ReferenceSchema.Builder refBuilder = ReferenceSchema.builder();
        this.pointerSchemas.put(absPointerString, refBuilder);
        JSONPointer.QueryResult result = pointer.query();
        SchemaLoader childLoader = new SchemaLoader(this.id, result.getQueryResult(), result.getContainingDocument(), this.pointerSchemas, this.httpClient);
        Object referredSchema = childLoader.load().build();
        refBuilder.build().setReferredSchema((Schema)referredSchema);
        return refBuilder;
    }

    private boolean schemaHasAnyOf(Collection<String> propNames) {
        return propNames.stream().filter(arg_0 -> ((JSONObject)this.schemaJson).has(arg_0)).findAny().isPresent();
    }

    private Schema.Builder<?> sniffSchemaByProps() {
        if (this.schemaHasAnyOf(ARRAY_SCHEMA_PROPS)) {
            return this.buildArraySchema().requiresArray(false);
        }
        if (this.schemaHasAnyOf(OBJECT_SCHEMA_PROPS)) {
            return this.buildObjectSchema().requiresObject(false);
        }
        if (this.schemaHasAnyOf(NUMBER_SCHEMA_PROPS)) {
            return this.buildNumberSchema().requiresNumber(false);
        }
        if (this.schemaHasAnyOf(STRING_SCHEMA_PROPS)) {
            return this.buildStringSchema().requiresString(false);
        }
        return null;
    }

    private CombinedSchema.Builder tryCombinedSchema() {
        List presentKeys = COMBINED_SUBSCHEMA_PROVIDERS.keySet().stream().filter(arg_0 -> ((JSONObject)this.schemaJson).has(arg_0)).collect(Collectors.toList());
        if (presentKeys.size() > 1) {
            throw new SchemaException(String.format("expected at most 1 of 'allOf', 'anyOf', 'oneOf', %d found", presentKeys.size()));
        }
        if (presentKeys.size() == 1) {
            String key = (String)presentKeys.get(0);
            JSONArray subschemaDefs = this.schemaJson.getJSONArray(key);
            Collection subschemas = IntStream.range(0, subschemaDefs.length()).mapToObj(arg_0 -> ((JSONArray)subschemaDefs).getJSONObject(arg_0)).map(this::loadChild).map(Schema.Builder::build).collect(Collectors.toList());
            CombinedSchema.Builder combinedSchema = COMBINED_SUBSCHEMA_PROVIDERS.get(key).apply(subschemas);
            Schema.Builder<?> baseSchema = this.schemaJson.has("type") ? this.loadForType(this.schemaJson.get("type")) : this.sniffSchemaByProps();
            if (baseSchema == null) {
                return combinedSchema;
            }
            return CombinedSchema.allOf(Arrays.asList(baseSchema.build(), combinedSchema.build()));
        }
        return null;
    }

    TypeBasedMultiplexer typeMultiplexer(Object obj) {
        return new TypeBasedMultiplexer(obj);
    }

    TypeBasedMultiplexer typeMultiplexer(String keyOfObj, Object obj) {
        return new TypeBasedMultiplexer(keyOfObj, obj);
    }

    static {
        COMBINED_SUBSCHEMA_PROVIDERS.put("allOf", CombinedSchema::allOf);
        COMBINED_SUBSCHEMA_PROVIDERS.put("anyOf", CombinedSchema::anyOf);
        COMBINED_SUBSCHEMA_PROVIDERS.put("oneOf", CombinedSchema::oneOf);
    }

    class TypeBasedMultiplexer {
        private final String keyOfObj;
        private final Object obj;
        private final Map<Class<?>, Consumer<?>> actions = new HashMap();

        public TypeBasedMultiplexer(Object obj) {
            this(null, obj);
        }

        public TypeBasedMultiplexer(String keyOfObj, Object obj) {
            this.keyOfObj = keyOfObj;
            this.obj = obj;
        }

        public <E> OnTypeConsumer<E> ifIs(Class<E> predicateClass) {
            if (predicateClass == JSONObject.class) {
                throw new IllegalArgumentException("use ifObject() instead");
            }
            return new OnTypeConsumerImpl(predicateClass);
        }

        public OnTypeConsumer<JSONObject> ifObject() {
            return new IdModifyingTypeConsumerImpl(JSONObject.class);
        }

        public void orElse(Consumer<Object> orElseConsumer) {
            Consumer<Object> consumer = this.actions.keySet().stream().filter(clazz -> clazz.isAssignableFrom(this.obj.getClass())).findFirst().map(this.actions::get).orElse(orElseConsumer::accept);
            consumer.accept(this.obj);
        }

        public void requireAny() {
            this.orElse(obj -> {
                throw new SchemaException(this.keyOfObj, new ArrayList(this.actions.keySet()), obj);
            });
        }

        private class OnTypeConsumerImpl<E>
        implements OnTypeConsumer<E> {
            protected final Class<?> key;

            public OnTypeConsumerImpl(Class<?> key) {
                this.key = key;
            }

            @Override
            public TypeBasedMultiplexer then(Consumer<E> consumer) {
                TypeBasedMultiplexer.this.actions.put(this.key, consumer);
                return TypeBasedMultiplexer.this;
            }
        }

        private class IdModifyingTypeConsumerImpl
        extends OnTypeConsumerImpl<JSONObject> {
            public IdModifyingTypeConsumerImpl(Class<?> key) {
                super(key);
            }

            @Override
            public TypeBasedMultiplexer then(Consumer<JSONObject> consumer) {
                Consumer<JSONObject> wrapperConsumer = obj -> {
                    String origId = SchemaLoader.this.id;
                    if (obj.has("id")) {
                        SchemaLoader.this.id = SchemaLoader.this.id + obj.getString("id");
                    }
                    consumer.accept((JSONObject)obj);
                    SchemaLoader.this.id = origId;
                };
                TypeBasedMultiplexer.this.actions.put(this.key, wrapperConsumer);
                return TypeBasedMultiplexer.this;
            }
        }
    }

    @FunctionalInterface
    static interface OnTypeConsumer<E> {
        public TypeBasedMultiplexer then(Consumer<E> var1);
    }
}

