/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff.output.changelog.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import liquibase.change.Change;
import liquibase.change.core.LoadDataChange;
import liquibase.change.core.LoadDataColumnConfig;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.diff.output.changelog.core.MissingDataChangeGenerator;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.servicelocator.LiquibaseService;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Data;
import liquibase.structure.core.Table;
import liquibase.util.ISODateFormat;
import liquibase.util.JdbcUtils;
import liquibase.util.csv.CSVWriter;

@LiquibaseService(skip=true)
public class MissingDataExternalFileChangeGenerator
extends MissingDataChangeGenerator {
    private String dataDir;

    public MissingDataExternalFileChangeGenerator(String dataDir) {
        this.dataDir = dataDir;
    }

    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (Data.class.isAssignableFrom(objectType)) {
            return 50;
        }
        return -1;
    }

    @Override
    public Change[] fixMissing(DatabaseObject missingObject, DiffOutputControl outputControl, Database referenceDatabase, Database comparisionDatabase, ChangeGeneratorChain chain) {
        Change[] changeArray;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            int i;
            File parentDir;
            Data data = (Data)missingObject;
            Table table = data.getTable();
            if (referenceDatabase.isLiquibaseObject(table)) {
                Change[] changeArray2 = null;
                return changeArray2;
            }
            String sql = "SELECT * FROM " + referenceDatabase.escapeTableName(table.getSchema().getCatalogName(), table.getSchema().getName(), table.getName());
            stmt = ((JdbcConnection)referenceDatabase.getConnection()).createStatement(1003, 1007);
            stmt.setFetchSize(1000);
            rs = stmt.executeQuery(sql);
            ArrayList<String> columnNames = new ArrayList<String>();
            for (int i2 = 0; i2 < rs.getMetaData().getColumnCount(); ++i2) {
                columnNames.add(rs.getMetaData().getColumnName(i2 + 1));
            }
            String fileName = table.getName().toLowerCase() + ".csv";
            if (this.dataDir != null) {
                fileName = this.dataDir + "/" + fileName;
            }
            if (!(parentDir = new File(this.dataDir)).exists()) {
                parentDir.mkdirs();
            }
            if (!parentDir.isDirectory()) {
                throw new RuntimeException(parentDir + " is not a directory");
            }
            CSVWriter outputFile = new CSVWriter(new BufferedWriter(new FileWriter(fileName)));
            String[] dataTypes = new String[columnNames.size()];
            String[] line = new String[columnNames.size()];
            for (i = 0; i < columnNames.size(); ++i) {
                line[i] = (String)columnNames.get(i);
            }
            outputFile.writeNext(line);
            while (rs.next()) {
                line = new String[columnNames.size()];
                for (i = 0; i < columnNames.size(); ++i) {
                    Object value = JdbcUtils.getResultSetValue(rs, i + 1);
                    if (dataTypes[i] == null && value != null) {
                        dataTypes[i] = value instanceof Number ? "NUMERIC" : (value instanceof Boolean ? "BOOLEAN" : (value instanceof Date ? "DATE" : "STRING"));
                    }
                    line[i] = value == null ? "NULL" : (value instanceof Date ? new ISODateFormat().format((Date)value) : value.toString());
                }
                outputFile.writeNext(line);
            }
            outputFile.flush();
            outputFile.close();
            LoadDataChange change = new LoadDataChange();
            change.setFile(fileName);
            change.setEncoding("UTF-8");
            if (outputControl.isIncludeCatalog()) {
                change.setCatalogName(table.getSchema().getCatalogName());
            }
            if (outputControl.isIncludeSchema()) {
                change.setSchemaName(table.getSchema().getName());
            }
            change.setTableName(table.getName());
            for (int i3 = 0; i3 < columnNames.size(); ++i3) {
                String colName = (String)columnNames.get(i3);
                LoadDataColumnConfig columnConfig = new LoadDataColumnConfig();
                columnConfig.setHeader(colName);
                columnConfig.setName(colName);
                columnConfig.setType(dataTypes[i3]);
                change.addColumn(columnConfig);
            }
            changeArray = new Change[]{change};
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ignore) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ignore) {}
            }
        }
        return changeArray;
    }
}

