/*
 * Decompiled with CFR 0.152.
 */
package liquibase.lockservice;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import liquibase.database.Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.LockException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.lockservice.DatabaseChangeLogLock;
import liquibase.lockservice.LockService;
import liquibase.logging.LogFactory;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.statement.core.CreateDatabaseChangeLogLockTableStatement;
import liquibase.statement.core.DropTableStatement;
import liquibase.statement.core.InitializeDatabaseChangeLogLockTableStatement;
import liquibase.statement.core.LockDatabaseChangeLogStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.statement.core.SelectFromDatabaseChangeLogLockStatement;
import liquibase.statement.core.UnlockDatabaseChangeLogStatement;
import liquibase.structure.core.Table;

public class StandardLockService
implements LockService {
    private Database database;
    private boolean hasChangeLogLock = false;
    private long changeLogLockWaitTime = 300000L;
    private long changeLogLocRecheckTime = 10000L;
    public static final String LOCK_WAIT_TIME_SYSTEM_PROPERTY = "liquibase.changeLogLockWaitTimeInMinutes";
    private boolean hasDatabaseChangeLogLockTable = false;
    private boolean isDatabaseChangeLogLockTableInitialized = false;

    public StandardLockService() {
        try {
            this.changeLogLockWaitTime = 60000L * Long.parseLong(System.getProperty(LOCK_WAIT_TIME_SYSTEM_PROPERTY));
            LogFactory.getLogger().info("lockWaitTime change to: " + this.changeLogLockWaitTime);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public boolean supports(Database database) {
        return true;
    }

    @Override
    public void setDatabase(Database database) {
        this.database = database;
    }

    @Override
    public void setChangeLogLockWaitTime(long changeLogLockWaitTime) {
        this.changeLogLockWaitTime = changeLogLockWaitTime;
    }

    @Override
    public void setChangeLogLockRecheckTime(long changeLogLocRecheckTime) {
        this.changeLogLocRecheckTime = changeLogLocRecheckTime;
    }

    @Override
    public void init() throws DatabaseException {
        boolean createdTable = false;
        Executor executor = ExecutorService.getInstance().getExecutor(this.database);
        if (!this.hasDatabaseChangeLogLockTable()) {
            executor.comment("Create Database Lock Table");
            executor.execute(new CreateDatabaseChangeLogLockTableStatement());
            this.database.commit();
            LogFactory.getLogger().debug("Created database lock table with name: " + this.database.escapeTableName(this.database.getLiquibaseCatalogName(), this.database.getLiquibaseSchemaName(), this.database.getDatabaseChangeLogLockTableName()));
            this.hasDatabaseChangeLogLockTable = true;
            createdTable = true;
        }
        if (!this.isDatabaseChangeLogLockTableInitialized(createdTable)) {
            executor.comment("Initialize Database Lock Table");
            executor.execute(new InitializeDatabaseChangeLogLockTableStatement());
            this.database.commit();
        }
        if (this.database instanceof DerbyDatabase && ((DerbyDatabase)this.database).supportsBooleanDataType()) {
            String lockTable = this.database.escapeTableName(this.database.getLiquibaseCatalogName(), this.database.getLiquibaseSchemaName(), this.database.getDatabaseChangeLogLockTableName());
            Object obj = executor.queryForObject(new RawSqlStatement("select min(locked) as test from " + lockTable + " fetch first row only"), Object.class);
            if (!(obj instanceof Boolean)) {
                executor.execute(new DropTableStatement(this.database.getLiquibaseCatalogName(), this.database.getLiquibaseSchemaName(), this.database.getDatabaseChangeLogLockTableName(), false));
                executor.execute(new CreateDatabaseChangeLogLockTableStatement());
                executor.execute(new InitializeDatabaseChangeLogLockTableStatement());
            }
        }
    }

    public boolean isDatabaseChangeLogLockTableInitialized(boolean tableJustCreated) throws DatabaseException {
        boolean initialized;
        Executor executor = ExecutorService.getInstance().getExecutor(this.database);
        try {
            initialized = executor.queryForInt(new RawSqlStatement("select count(*) from " + this.database.escapeTableName(this.database.getLiquibaseCatalogName(), this.database.getLiquibaseSchemaName(), this.database.getDatabaseChangeLogLockTableName()))) > 0;
        }
        catch (LiquibaseException e) {
            if (executor.updatesDatabase()) {
                throw new UnexpectedLiquibaseException(e);
            }
            initialized = !tableJustCreated;
        }
        return initialized;
    }

    @Override
    public boolean hasChangeLogLock() {
        return this.hasChangeLogLock;
    }

    public boolean hasDatabaseChangeLogLockTable() throws DatabaseException {
        boolean hasTable = false;
        try {
            hasTable = SnapshotGeneratorFactory.getInstance().hasDatabaseChangeLogLockTable(this.database);
        }
        catch (LiquibaseException e) {
            throw new UnexpectedLiquibaseException(e);
        }
        return hasTable;
    }

    @Override
    public void waitForLock() throws LockException {
        boolean locked = false;
        long timeToGiveUp = new Date().getTime() + this.changeLogLockWaitTime;
        while (!locked && new Date().getTime() < timeToGiveUp) {
            locked = this.acquireLock();
            if (locked) continue;
            LogFactory.getLogger().info("Waiting for changelog lock....");
            try {
                Thread.sleep(this.changeLogLocRecheckTime);
            }
            catch (InterruptedException e) {}
        }
        if (!locked) {
            String lockedBy;
            DatabaseChangeLogLock[] locks = this.listLocks();
            if (locks.length > 0) {
                DatabaseChangeLogLock lock = locks[0];
                lockedBy = lock.getLockedBy() + " since " + DateFormat.getDateTimeInstance(3, 3).format(lock.getLockGranted());
            } else {
                lockedBy = "UNKNOWN";
            }
            throw new LockException("Could not acquire change log lock.  Currently locked by " + lockedBy);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean acquireLock() throws LockException {
        if (this.hasChangeLogLock) {
            return true;
        }
        Executor executor = ExecutorService.getInstance().getExecutor(this.database);
        try {
            this.database.rollback();
            this.init();
            Boolean locked = ExecutorService.getInstance().getExecutor(this.database).queryForObject(new SelectFromDatabaseChangeLogLockStatement("LOCKED"), Boolean.class);
            if (locked.booleanValue()) {
                boolean bl = false;
                return bl;
            }
            executor.comment("Lock Database");
            int rowsUpdated = executor.update(new LockDatabaseChangeLogStatement());
            if (rowsUpdated > 1) {
                throw new LockException("Did not update change log lock correctly");
            }
            if (rowsUpdated == 0) {
                boolean bl = false;
                return bl;
            }
            this.database.commit();
            LogFactory.getLogger().info("Successfully acquired change log lock");
            this.hasChangeLogLock = true;
            this.database.setCanCacheLiquibaseTableInfo(true);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new LockException(e);
        }
        finally {
            try {
                this.database.rollback();
            }
            catch (DatabaseException e) {}
        }
    }

    @Override
    public void releaseLock() throws LockException {
        Executor executor = ExecutorService.getInstance().getExecutor(this.database);
        try {
            if (this.hasDatabaseChangeLogLockTable()) {
                executor.comment("Release Database Lock");
                this.database.rollback();
                int updatedRows = executor.update(new UnlockDatabaseChangeLogStatement());
                if (updatedRows != 1) {
                    throw new LockException("Did not update change log lock correctly.\n\n" + updatedRows + " rows were updated instead of the expected 1 row using executor " + executor.getClass().getName() + " there are " + executor.queryForInt(new RawSqlStatement("select count(*) from " + this.database.getDatabaseChangeLogLockTableName())) + " rows in the table");
                }
                this.database.commit();
            }
        }
        catch (Exception e) {
            throw new LockException(e);
        }
        finally {
            try {
                this.hasChangeLogLock = false;
                this.database.setCanCacheLiquibaseTableInfo(false);
                LogFactory.getLogger().info("Successfully released change log lock");
                this.database.rollback();
            }
            catch (DatabaseException e) {}
        }
    }

    @Override
    public DatabaseChangeLogLock[] listLocks() throws LockException {
        try {
            if (!this.hasDatabaseChangeLogLockTable()) {
                return new DatabaseChangeLogLock[0];
            }
            ArrayList<DatabaseChangeLogLock> allLocks = new ArrayList<DatabaseChangeLogLock>();
            SelectFromDatabaseChangeLogLockStatement sqlStatement = new SelectFromDatabaseChangeLogLockStatement("ID", "LOCKED", "LOCKGRANTED", "LOCKEDBY");
            List<Map<String, ?>> rows = ExecutorService.getInstance().getExecutor(this.database).queryForList(sqlStatement);
            for (Map<String, ?> columnMap : rows) {
                Object lockedValue = columnMap.get("LOCKED");
                Boolean locked = lockedValue instanceof Number ? Boolean.valueOf(((Number)lockedValue).intValue() == 1) : (Boolean)lockedValue;
                if (locked == null || !locked.booleanValue()) continue;
                allLocks.add(new DatabaseChangeLogLock(((Number)columnMap.get("ID")).intValue(), (Date)columnMap.get("LOCKGRANTED"), (String)columnMap.get("LOCKEDBY")));
            }
            return allLocks.toArray(new DatabaseChangeLogLock[allLocks.size()]);
        }
        catch (Exception e) {
            throw new LockException(e);
        }
    }

    @Override
    public void forceReleaseLock() throws LockException, DatabaseException {
        this.init();
        this.releaseLock();
    }

    @Override
    public void reset() {
        this.hasChangeLogLock = false;
    }

    @Override
    public void destroy() throws DatabaseException {
        try {
            if (SnapshotGeneratorFactory.getInstance().has(new Table().setName(this.database.getDatabaseChangeLogLockTableName()).setSchema(this.database.getLiquibaseCatalogName(), this.database.getLiquibaseSchemaName()), this.database)) {
                ExecutorService.getInstance().getExecutor(this.database).execute(new DropTableStatement(this.database.getLiquibaseCatalogName(), this.database.getLiquibaseSchemaName(), this.database.getDatabaseChangeLogLockTableName(), false));
            }
        }
        catch (InvalidExampleException e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }
}

