/*
 * Decompiled with CFR 0.152.
 */
package liquibase.servicelocator;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;
import liquibase.exception.ServiceNotFoundException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.logging.Logger;
import liquibase.logging.core.DefaultLogger;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.servicelocator.DefaultPackageScanClassResolver;
import liquibase.servicelocator.LiquibaseService;
import liquibase.servicelocator.PackageScanClassResolver;
import liquibase.servicelocator.PrioritizedService;
import liquibase.servicelocator.WebSpherePackageScanClassResolver;
import liquibase.util.StringUtils;
import org.everit.osgi.liquibase.bundle.OSGiResourceAccessor;
import org.everit.osgi.liquibase.bundle.internal.BundlePackageScanClassResolver;
import org.everit.osgi.liquibase.bundle.internal.SimpleClassLoaderResourceAccessor;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ServiceLocator {
    private static ServiceLocator instance;
    private ResourceAccessor resourceAccessor;
    private Map<Class, List<Class>> classesBySuperclass;
    private List<String> packagesToScan;
    private Logger logger = new DefaultLogger();
    private PackageScanClassResolver classResolver;

    protected ServiceLocator() {
        this.classResolver = this.defaultClassLoader();
        this.setResourceAccessor(new ClassLoaderResourceAccessor());
    }

    protected ServiceLocator(ResourceAccessor accessor) {
        this.classResolver = this.defaultClassLoader();
        this.setResourceAccessor(accessor);
    }

    protected ServiceLocator(PackageScanClassResolver classResolver) {
        this.classResolver = classResolver;
        this.setResourceAccessor(new ClassLoaderResourceAccessor());
    }

    protected ServiceLocator(PackageScanClassResolver classResolver, ResourceAccessor accessor) {
        this.classResolver = classResolver;
        this.setResourceAccessor(accessor);
    }

    public static ServiceLocator getInstance() {
        return instance;
    }

    public static void setInstance(ServiceLocator newInstance) {
        instance = newInstance;
    }

    private PackageScanClassResolver defaultClassLoader() {
        if (WebSpherePackageScanClassResolver.isWebSphereClassLoader(this.getClass().getClassLoader())) {
            this.logger.debug("Using WebSphere Specific Class Resolver");
            return new WebSpherePackageScanClassResolver("liquibase/parser/core/xml/dbchangelog-2.0.xsd");
        }
        return new DefaultPackageScanClassResolver();
    }

    public void setResourceAccessor(ResourceAccessor resourceAccessor) {
        this.resourceAccessor = resourceAccessor;
        this.classesBySuperclass = new HashMap<Class, List<Class>>();
        this.classResolver.setClassLoaders(new HashSet<ClassLoader>(Arrays.asList(resourceAccessor.toClassLoader())));
        this.packagesToScan = new ArrayList<String>();
        String packagesToScanSystemProp = System.getProperty("liquibase.scan.packages");
        if (packagesToScanSystemProp != null && (packagesToScanSystemProp = StringUtils.trimToNull(packagesToScanSystemProp)) != null) {
            for (String value : packagesToScanSystemProp.split(",")) {
                this.addPackageToScan(value);
            }
        } else {
            Enumeration<URL> manifests = null;
            try {
                manifests = resourceAccessor.getResources("META-INF/MANIFEST.MF");
                while (manifests.hasMoreElements()) {
                    URL url = manifests.nextElement();
                    InputStream is = url.openStream();
                    Manifest manifest = new Manifest(is);
                    String attributes = StringUtils.trimToNull(manifest.getMainAttributes().getValue("Liquibase-Package"));
                    if (attributes != null) {
                        for (String value : attributes.split(",")) {
                            this.addPackageToScan(value.toString());
                        }
                    }
                    is.close();
                }
            }
            catch (IOException e) {
                throw new UnexpectedLiquibaseException(e);
            }
            if (this.packagesToScan.size() == 0) {
                this.addPackageToScan("liquibase.change");
                this.addPackageToScan("liquibase.database");
                this.addPackageToScan("liquibase.parser");
                this.addPackageToScan("liquibase.precondition");
                this.addPackageToScan("liquibase.datatype");
                this.addPackageToScan("liquibase.serializer");
                this.addPackageToScan("liquibase.sqlgenerator");
                this.addPackageToScan("liquibase.executor");
                this.addPackageToScan("liquibase.snapshot");
                this.addPackageToScan("liquibase.logging");
                this.addPackageToScan("liquibase.diff");
                this.addPackageToScan("liquibase.structure");
                this.addPackageToScan("liquibase.structurecompare");
                this.addPackageToScan("liquibase.lockservice");
                this.addPackageToScan("liquibase.ext");
            }
        }
    }

    public void addPackageToScan(String packageName) {
        this.logger.debug("Adding package to scan: " + packageName);
        this.packagesToScan.add(packageName);
    }

    public Class findClass(Class requiredInterface) throws ServiceNotFoundException {
        Class<T>[] classes = this.findClasses(requiredInterface);
        if (PrioritizedService.class.isAssignableFrom(requiredInterface)) {
            Object returnObject = null;
            for (Class clazz : classes) {
                PrioritizedService newInstance;
                try {
                    newInstance = (PrioritizedService)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new UnexpectedLiquibaseException(e);
                }
                if (returnObject != null && newInstance.getPriority() <= returnObject.getPriority()) continue;
                returnObject = newInstance;
            }
            if (returnObject == null) {
                throw new ServiceNotFoundException("Could not find implementation of " + requiredInterface.getName());
            }
            return returnObject.getClass();
        }
        if (classes.length != 1) {
            throw new ServiceNotFoundException("Could not find unique implementation of " + requiredInterface.getName() + ".  Found " + classes.length + " implementations");
        }
        return classes[0];
    }

    public <T> Class<? extends T>[] findClasses(Class<T> requiredInterface) throws ServiceNotFoundException {
        this.logger.debug("ServiceLocator.findClasses for " + requiredInterface.getName());
        try {
            Class.forName(requiredInterface.getName());
            if (!this.classesBySuperclass.containsKey(requiredInterface)) {
                this.classesBySuperclass.put(requiredInterface, this.findClassesImpl(requiredInterface));
            }
        }
        catch (Exception e) {
            throw new ServiceNotFoundException(e);
        }
        List<Class> classes = this.classesBySuperclass.get(requiredInterface);
        HashSet<Class> uniqueClasses = new HashSet<Class>(classes);
        return uniqueClasses.toArray(new Class[uniqueClasses.size()]);
    }

    public Object newInstance(Class requiredInterface) throws ServiceNotFoundException {
        try {
            return this.findClass(requiredInterface).newInstance();
        }
        catch (Exception e) {
            throw new ServiceNotFoundException(e);
        }
    }

    private List<Class> findClassesImpl(Class requiredInterface) throws Exception {
        this.logger.debug("ServiceLocator finding classes matching interface " + requiredInterface.getName());
        ArrayList<Class> classes = new ArrayList<Class>();
        this.classResolver.addClassLoader(this.resourceAccessor.toClassLoader());
        for (Class<?> clazz : this.classResolver.findImplementations(requiredInterface, this.packagesToScan.toArray(new String[this.packagesToScan.size()]))) {
            if (clazz.getAnnotation(LiquibaseService.class) != null && clazz.getAnnotation(LiquibaseService.class).skip() || Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers()) || !Modifier.isPublic(clazz.getModifiers())) continue;
            try {
                clazz.getConstructor(new Class[0]);
                this.logger.debug(clazz.getName() + " matches " + requiredInterface.getName());
                classes.add(clazz);
            }
            catch (NoSuchMethodException e) {
                this.logger.info("Can not use " + clazz + " as a Liquibase service because it does not have a no-argument constructor");
            }
            catch (NoClassDefFoundError e) {
                String message = "Can not use " + clazz + " as a Liquibase service because " + e.getMessage().replace("/", ".") + " is not in the classpath";
                if (e.getMessage().startsWith("org/yaml/snakeyaml")) {
                    this.logger.info(message);
                    continue;
                }
                this.logger.warning(message);
            }
        }
        return classes;
    }

    public static void reset() {
        instance = null;
        try {
            Bundle bundle = FrameworkUtil.getBundle(ServiceLocator.class);
            if (bundle != null) {
                BundlePackageScanClassResolver classResolver = new BundlePackageScanClassResolver(bundle);
                OSGiResourceAccessor resourceAccessor = new OSGiResourceAccessor(bundle);
                instance = new ServiceLocator(classResolver, resourceAccessor);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        if (instance == null) {
            instance = new ServiceLocator(new SimpleClassLoaderResourceAccessor(ServiceLocator.class.getClassLoader()));
        }
    }

    protected Logger getLogger() {
        return this.logger;
    }

    static {
        ServiceLocator.reset();
    }
}

