/*
 * Decompiled with CFR 0.152.
 */
package liquibase.structure.core;

import java.util.ArrayList;
import java.util.List;
import liquibase.structure.AbstractDatabaseObject;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.ForeignKeyConstraintType;
import liquibase.structure.core.Index;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.util.StringUtils;

public class ForeignKey
extends AbstractDatabaseObject {
    @Override
    public DatabaseObject[] getContainingObjects() {
        ArrayList<Column> objects = new ArrayList<Column>();
        if (this.getPrimaryKeyColumns() != null) {
            for (String column : StringUtils.splitAndTrim(this.getPrimaryKeyColumns(), ",")) {
                objects.add(new Column().setName(column).setRelation(this.getPrimaryKeyTable()));
            }
        }
        if (this.getForeignKeyColumns() != null) {
            for (String column : StringUtils.splitAndTrim(this.getForeignKeyColumns(), ",")) {
                objects.add(new Column().setName(column).setRelation(this.getForeignKeyTable()));
            }
        }
        return objects.toArray(new DatabaseObject[objects.size()]);
    }

    @Override
    public Schema getSchema() {
        if (this.getForeignKeyTable() == null) {
            return null;
        }
        return this.getForeignKeyTable().getSchema();
    }

    public Table getPrimaryKeyTable() {
        return this.getAttribute("primaryKeyTable", Table.class);
    }

    public ForeignKey setPrimaryKeyTable(Table primaryKeyTable) {
        this.setAttribute("primaryKeyTable", primaryKeyTable);
        return this;
    }

    public String getPrimaryKeyColumns() {
        return this.getAttribute("primaryKeyColumns", String.class);
    }

    public void addPrimaryKeyColumn(String primaryKeyColumn) {
        if (this.getPrimaryKeyColumns() == null || this.getPrimaryKeyColumns().length() == 0) {
            this.setPrimaryKeyColumns(primaryKeyColumn);
        } else {
            this.setPrimaryKeyColumns(this.getPrimaryKeyColumns() + ", " + primaryKeyColumn);
        }
    }

    public ForeignKey setPrimaryKeyColumns(String primaryKeyColumns) {
        this.setAttribute("primaryKeyColumns", primaryKeyColumns);
        return this;
    }

    public Table getForeignKeyTable() {
        return this.getAttribute("foreignKeyTable", Table.class);
    }

    public ForeignKey setForeignKeyTable(Table foreignKeyTable) {
        this.setAttribute("foreignKeyTable", foreignKeyTable);
        return this;
    }

    public String getForeignKeyColumns() {
        return this.getAttribute("foreignKeyColumns", String.class);
    }

    public void addForeignKeyColumn(String foreignKeyColumn) {
        if (this.getForeignKeyColumns() == null || this.getForeignKeyColumns().length() == 0) {
            this.setForeignKeyColumns(foreignKeyColumn);
        } else {
            this.setForeignKeyColumns(this.getForeignKeyColumns() + ", " + foreignKeyColumn);
        }
    }

    public ForeignKey setForeignKeyColumns(String foreignKeyColumns) {
        this.setAttribute("foreignKeyColumns", foreignKeyColumns);
        return this;
    }

    @Override
    public String getName() {
        return this.getAttribute("name", String.class);
    }

    public ForeignKey setName(String name) {
        this.setAttribute("name", name);
        return this;
    }

    @Override
    public String toString() {
        return this.getName() + "(" + this.getForeignKeyTable() + "." + this.getForeignKeyColumns() + " -> " + this.getPrimaryKeyTable() + "." + this.getPrimaryKeyColumns() + ")";
    }

    public boolean isDeferrable() {
        return this.getAttribute("deferrable", Boolean.class);
    }

    public ForeignKey setDeferrable(boolean deferrable) {
        this.setAttribute("deferrable", deferrable);
        return this;
    }

    public boolean isInitiallyDeferred() {
        return this.getAttribute("initiallyDeferred", Boolean.class);
    }

    public ForeignKey setInitiallyDeferred(boolean initiallyDeferred) {
        this.setAttribute("initiallyDeferred", initiallyDeferred);
        return this;
    }

    public ForeignKey setUpdateRule(ForeignKeyConstraintType rule) {
        this.setAttribute("updateRule", (Object)rule);
        return this;
    }

    public ForeignKeyConstraintType getUpdateRule() {
        return this.getAttribute("updateRule", ForeignKeyConstraintType.class);
    }

    public ForeignKey setDeleteRule(ForeignKeyConstraintType rule) {
        this.setAttribute("deleteRule", (Object)rule);
        return this;
    }

    public ForeignKeyConstraintType getDeleteRule() {
        return this.getAttribute("deleteRule", ForeignKeyConstraintType.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForeignKey that = (ForeignKey)o;
        if (this.getForeignKeyColumns() == null) {
            return this.getName().equalsIgnoreCase(that.getName());
        }
        return this.getForeignKeyColumns() != null && that.getForeignKeyColumns() != null && this.getForeignKeyColumns().equalsIgnoreCase(that.getForeignKeyColumns()) && this.getForeignKeyTable() != null && that.getForeignKeyTable() != null && this.getForeignKeyTable().equals(that.getForeignKeyTable()) && this.getPrimaryKeyColumns() != null && that.getPrimaryKeyColumns() != null && this.getPrimaryKeyColumns().equalsIgnoreCase(that.getPrimaryKeyColumns()) && this.getPrimaryKeyTable() != null && that.getPrimaryKeyTable() != null && this.getPrimaryKeyTable().equals(that.getPrimaryKeyTable());
    }

    public int hashCode() {
        int result = 0;
        if (this.getPrimaryKeyTable() != null) {
            result = this.getPrimaryKeyTable().hashCode();
        }
        if (this.getPrimaryKeyColumns() != null) {
            result = 31 * result + this.getPrimaryKeyColumns().toUpperCase().hashCode();
        }
        if (this.getForeignKeyTable() != null) {
            result = 31 * result + this.getForeignKeyTable().hashCode();
        }
        if (this.getForeignKeyColumns() != null) {
            result = 31 * result + this.getForeignKeyColumns().toUpperCase().hashCode();
        }
        return result;
    }

    @Override
    public int compareTo(Object other) {
        ForeignKey o = (ForeignKey)other;
        int returnValue = 0;
        if (this.getForeignKeyTable() != null && o.getForeignKeyTable() != null) {
            returnValue = this.getForeignKeyTable().compareTo(o.getForeignKeyTable());
        }
        if (returnValue == 0 && this.getForeignKeyColumns() != null && o.getForeignKeyColumns() != null) {
            returnValue = this.getForeignKeyColumns().compareToIgnoreCase(o.getForeignKeyColumns());
        }
        if (returnValue == 0 && this.getName() != null && o.getName() != null) {
            returnValue = this.getName().compareToIgnoreCase(o.getName());
        }
        if (returnValue == 0 && this.getPrimaryKeyTable() != null && o.getPrimaryKeyTable() != null) {
            returnValue = this.getPrimaryKeyTable().compareTo(o.getPrimaryKeyTable());
        }
        if (returnValue == 0 && this.getPrimaryKeyColumns() != null && o.getPrimaryKeyColumns() != null) {
            returnValue = this.getPrimaryKeyColumns().compareToIgnoreCase(o.getPrimaryKeyColumns());
        }
        if (returnValue == 0 && this.getUpdateRule() != null && o.getUpdateRule() != null) {
            returnValue = this.getUpdateRule().compareTo(o.getUpdateRule());
        }
        if (returnValue == 0 && this.getDeleteRule() != null && o.getDeleteRule() != null) {
            returnValue = this.getDeleteRule().compareTo(o.getDeleteRule());
        }
        return returnValue;
    }

    private String toDisplayString(List<String> columnsNames) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String columnName : columnsNames) {
            sb.append(columnName);
            if (++i >= columnsNames.size()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public Index getBackingIndex() {
        return this.getAttribute("backingIndex", Index.class);
    }

    public ForeignKey setBackingIndex(Index backingIndex) {
        this.setAttribute("backingIndex", backingIndex);
        return this;
    }
}

