/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.liquibase.bundle;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.felix.utils.manifest.Attribute;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Directive;
import org.apache.felix.utils.manifest.Parser;
import org.everit.osgi.liquibase.bundle.SchemaExpressionSyntaxException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public final class LiquibaseOSGiUtil {
    public static final String LIQUIBASE_CAPABILITY_NS = "liquibase.schema";
    public static final String ATTR_SCHEMA_NAME = "name";
    public static final String ATTR_SCHEMA_RESOURCE = "resource";
    public static final String INCLUDE_FILE_OSGI_PREFIX = "eosgi:";

    public static Filter createFilterForLiquibaseCapabilityAttributes(String schemaExpression) {
        Clause[] clauses = Parser.parseClauses((String[])new String[]{schemaExpression});
        if (clauses.length != 1) {
            throw new SchemaExpressionSyntaxException("The number of Clauses in the Schema expression should be 1");
        }
        Clause clause = clauses[0];
        String schemaName = clause.getName();
        Attribute[] attributes = clause.getAttributes();
        if (attributes.length > 0) {
            throw new SchemaExpressionSyntaxException("No Attributes in the schema expresson are supported.");
        }
        Directive[] directives = clause.getDirectives();
        if (directives.length > 1) {
            throw new SchemaExpressionSyntaxException("The number of Directives in the Schema expression should not be more than 1");
        }
        String filterString = "(name=" + schemaName + ")";
        if (directives.length == 1) {
            if (!"filter".equals(directives[0].getName())) {
                throw new SchemaExpressionSyntaxException("Only the 'filter' directive is supported in the schema expression");
            }
            String additionalFilterString = directives[0].getValue();
            filterString = "(&" + filterString + additionalFilterString + ")";
        }
        try {
            return FrameworkUtil.createFilter((String)filterString);
        }
        catch (InvalidSyntaxException e) {
            throw new SchemaExpressionSyntaxException("The filter contains an invalid filter string");
        }
    }

    public static Map<Bundle, List<BundleCapability>> findBundlesBySchemaExpression(String schemaExpression, BundleContext bundleContext, int necessaryBundleStates) {
        Bundle[] bundles;
        Filter filter = LiquibaseOSGiUtil.createFilterForLiquibaseCapabilityAttributes(schemaExpression);
        TreeMap<Bundle, List<BundleCapability>> result = new TreeMap<Bundle, List<BundleCapability>>(new Comparator<Bundle>(){

            @Override
            public int compare(Bundle o1, Bundle o2) {
                long bundle2Id;
                long bundle1Id = o1.getBundleId();
                if (bundle1Id == (bundle2Id = o2.getBundleId())) {
                    return 0;
                }
                if (bundle1Id < bundle2Id) {
                    return -1;
                }
                return 1;
            }
        });
        for (Bundle bundle : bundles = bundleContext.getBundles()) {
            int state = bundle.getState();
            if ((state & necessaryBundleStates) == 0) continue;
            BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            List capabilities = bundleWiring.getCapabilities(LIQUIBASE_CAPABILITY_NS);
            for (BundleCapability capability : capabilities) {
                Map attributes = capability.getAttributes();
                if (attributes.get(ATTR_SCHEMA_RESOURCE) == null || !filter.matches(attributes)) continue;
                ArrayList<BundleCapability> capabilityList = (ArrayList<BundleCapability>)result.get(bundle);
                if (capabilityList == null) {
                    capabilityList = new ArrayList<BundleCapability>();
                    result.put(bundle, capabilityList);
                }
                capabilityList.add(capability);
            }
        }
        return result;
    }

    public static final BundleWire findMatchingWireBySchemaExpression(Bundle currentBundle, String schemaExpression) {
        BundleWiring bundleWiring = (BundleWiring)currentBundle.adapt(BundleWiring.class);
        List wires = bundleWiring.getRequiredWires(LIQUIBASE_CAPABILITY_NS);
        if (wires.size() == 0) {
            return null;
        }
        Filter capabilityFilter = LiquibaseOSGiUtil.createFilterForLiquibaseCapabilityAttributes(schemaExpression);
        Iterator iterator = wires.iterator();
        BundleWire matchingWire = null;
        while (matchingWire == null && iterator.hasNext()) {
            Object schemaResourceAttr;
            BundleWire wire = (BundleWire)iterator.next();
            BundleCapability capability = wire.getCapability();
            Map capabilityAttributes = capability.getAttributes();
            if (!capabilityFilter.matches(capabilityAttributes) || (schemaResourceAttr = capabilityAttributes.get(ATTR_SCHEMA_RESOURCE)) == null) continue;
            matchingWire = wire;
        }
        return matchingWire;
    }

    private LiquibaseOSGiUtil() {
    }
}

