/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.liquibase.bundle;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class OSGiResourceAccessor
extends CompositeResourceAccessor {
    private final Bundle bundle;
    private final Map<String, Object> attributes;

    public OSGiResourceAccessor(Bundle bundle) {
        this(bundle, null);
    }

    public OSGiResourceAccessor(Bundle bundle, Map<String, Object> attributes) {
        super(new BundleResourceAccessor(bundle), new ClassLoaderResourceAccessor(OSGiResourceAccessor.class.getClassLoader()));
        this.bundle = bundle;
        this.attributes = attributes == null ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, Object>(attributes));
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    private static class BundleResourceAccessor
    implements ResourceAccessor {
        private ClassLoader bundleClassLoader;

        public BundleResourceAccessor(Bundle bundle) {
            BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            this.bundleClassLoader = bundleWiring.getClassLoader();
        }

        @Override
        public InputStream getResourceAsStream(String file) throws IOException {
            return this.bundleClassLoader.getResourceAsStream(file);
        }

        @Override
        public Enumeration<URL> getResources(String packageName) throws IOException {
            return this.bundleClassLoader.getResources(packageName);
        }

        @Override
        public ClassLoader toClassLoader() {
            return this.bundleClassLoader;
        }
    }
}

