/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.liquibase.bundle.internal;

import java.util.Collection;
import java.util.Set;
import liquibase.servicelocator.DefaultPackageScanClassResolver;
import liquibase.servicelocator.PackageScanFilter;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class BundlePackageScanClassResolver
extends DefaultPackageScanClassResolver {
    private final BundleWiring bundleWiring;

    public BundlePackageScanClassResolver(Bundle bundle) {
        this.bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
    }

    @Override
    protected void find(PackageScanFilter test, String packageName, Set<Class<?>> classes) {
        Collection names = this.bundleWiring.listResources(packageName = packageName.replace('.', '/'), "*.class", 1);
        if (names == null) {
            return;
        }
        ClassLoader bundleClassLoader = this.bundleWiring.getClassLoader();
        for (String name : names) {
            String fixedName = name.substring(0, name.indexOf(46)).replace('/', '.');
            try {
                Class<?> klass = bundleClassLoader.loadClass(fixedName);
                if (!test.matches(klass)) continue;
                classes.add(klass);
            }
            catch (ClassNotFoundException e) {
                this.log.debug("Cant load class: " + e.getMessage());
            }
        }
    }
}

