/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.liquibase.bundle.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StringUtils;

public class SimpleClassLoaderResourceAccessor
implements ResourceAccessor {
    private ClassLoader classLoader;

    public SimpleClassLoaderResourceAccessor() {
        this.classLoader = this.getClass().getClassLoader();
    }

    public SimpleClassLoaderResourceAccessor(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public InputStream getResourceAsStream(String file) throws IOException {
        return this.classLoader.getResourceAsStream(file);
    }

    @Override
    public Enumeration<URL> getResources(String packageName) throws IOException {
        return this.classLoader.getResources(packageName);
    }

    @Override
    public ClassLoader toClassLoader() {
        return this.classLoader;
    }

    public String toString() {
        String description;
        if (this.classLoader instanceof URLClassLoader) {
            ArrayList<String> urls = new ArrayList<String>();
            for (URL url : ((URLClassLoader)this.classLoader).getURLs()) {
                urls.add(url.toExternalForm());
            }
            description = StringUtils.join(urls, ",");
        } else {
            description = this.classLoader.getClass().getName();
        }
        return this.getClass().getName() + "(" + description + ")";
    }
}

