/*
 * Decompiled with CFR 0.152.
 */
package org.everit.osgi.liquibase.bundle.internal.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.exception.ChangeLogParseException;
import liquibase.logging.LogFactory;
import liquibase.parser.core.xml.LiquibaseEntityResolver;
import liquibase.parser.core.xml.XMLChangeLogSAXParser;
import liquibase.resource.ResourceAccessor;
import liquibase.resource.UtfBomStripperInputStream;
import liquibase.util.file.FilenameUtils;
import org.everit.osgi.liquibase.bundle.internal.parser.OSGiXMLChangeLogSAXHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class OSGiXMLChangeLogSAXParser
extends XMLChangeLogSAXParser {
    private SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
    private static ThreadLocal<Set<String>> processedChangeLogsOnThread = new ThreadLocal();

    public static Set<String> getProcessedChangeLogsOnThread() {
        return processedChangeLogsOnThread.get();
    }

    public static String getSchemaVersion() {
        return "3.1";
    }

    public OSGiXMLChangeLogSAXParser() {
        if (System.getProperty("java.vm.version").startsWith("1.4")) {
            this.saxParserFactory.setValidating(false);
            this.saxParserFactory.setNamespaceAware(false);
        } else {
            this.saxParserFactory.setValidating(true);
            this.saxParserFactory.setNamespaceAware(true);
        }
    }

    @Override
    public int getPriority() {
        return 2;
    }

    @Override
    public DatabaseChangeLog parse(String physicalChangeLogLocation, ChangeLogParameters changeLogParameters, ResourceAccessor resourceAccessor) throws ChangeLogParseException {
        boolean processedChangeLogsInitialized;
        InputStream inputStream = null;
        boolean bl = processedChangeLogsInitialized = processedChangeLogsOnThread.get() != null;
        if (!processedChangeLogsInitialized) {
            processedChangeLogsOnThread.set(new HashSet());
        }
        try {
            SAXParser parser = this.saxParserFactory.newSAXParser();
            try {
                parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            }
            catch (SAXNotRecognizedException e) {
            }
            catch (SAXNotSupportedException e) {
                // empty catch block
            }
            XMLReader xmlReader = parser.getXMLReader();
            LiquibaseEntityResolver resolver = new LiquibaseEntityResolver(this);
            resolver.useResoureAccessor(resourceAccessor, FilenameUtils.getFullPath(physicalChangeLogLocation));
            xmlReader.setEntityResolver(resolver);
            xmlReader.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    LogFactory.getLogger().severe(exception.getMessage());
                    throw exception;
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    LogFactory.getLogger().severe(exception.getMessage());
                    throw exception;
                }

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    LogFactory.getLogger().warning(exception.getMessage());
                    throw exception;
                }
            });
            inputStream = resourceAccessor.getResourceAsStream(physicalChangeLogLocation);
            if (inputStream == null) {
                throw new ChangeLogParseException(physicalChangeLogLocation + " does not exist");
            }
            OSGiXMLChangeLogSAXHandler contentHandler = new OSGiXMLChangeLogSAXHandler(physicalChangeLogLocation, resourceAccessor, changeLogParameters);
            xmlReader.setContentHandler(contentHandler);
            xmlReader.parse(new InputSource(new UtfBomStripperInputStream(inputStream)));
            DatabaseChangeLog databaseChangeLog = contentHandler.getDatabaseChangeLog();
            return databaseChangeLog;
        }
        catch (ChangeLogParseException e) {
            throw e;
        }
        catch (IOException e) {
            throw new ChangeLogParseException("Error Reading Migration File: " + e.getMessage(), e);
        }
        catch (SAXParseException e) {
            throw new ChangeLogParseException("Error parsing line " + e.getLineNumber() + " column " + e.getColumnNumber() + " of " + physicalChangeLogLocation + ": " + e.getMessage(), e);
        }
        catch (SAXException e) {
            for (Throwable parentCause = e.getException(); parentCause != null; parentCause = parentCause.getCause()) {
                if (!(parentCause instanceof ChangeLogParseException)) continue;
                throw (ChangeLogParseException)parentCause;
            }
            String reason = e.getMessage();
            String causeReason = null;
            if (e.getCause() != null) {
                causeReason = e.getCause().getMessage();
            }
            if (reason == null) {
                reason = causeReason != null ? causeReason : "Unknown Reason";
            }
            throw new ChangeLogParseException("Invalid Migration File: " + reason, e);
        }
        catch (Exception e) {
            throw new ChangeLogParseException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
            if (!processedChangeLogsInitialized) {
                processedChangeLogsOnThread.set(null);
            }
        }
    }

    @Override
    public boolean supports(String changeLogFile, ResourceAccessor resourceAccessor) {
        return changeLogFile.endsWith("xml");
    }
}

