/*
 * Copyright (c) 2012-2021 Codenvy, S.A.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Codenvy, S.A. - initial API and implementation
 */
package org.everrest.sample.guice;

import com.google.inject.Singleton;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;

/** @author andrew00x */
@Provider
@Singleton
public class BookNotFoundExceptionMapper implements ExceptionMapper<BookNotFoundException> {
  @Override
  public Response toResponse(BookNotFoundException exception) {
    return Response.status(404).entity((exception.getMessage() + "\n")).type("text/plain").build();
  }
}
