/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.spy;

import com.p6spy.engine.event.CompoundJdbcEventListener;
import com.p6spy.engine.event.DefaultEventListener;
import com.p6spy.engine.event.JdbcEventListener;
import com.p6spy.engine.spy.JdbcEventListenerFactory;
import com.p6spy.engine.spy.P6Factory;
import com.p6spy.engine.spy.P6ModuleManager;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public class DefaultJdbcEventListenerFactory
implements JdbcEventListenerFactory {
    private static ServiceLoader<JdbcEventListener> jdbcEventListenerServiceLoader = ServiceLoader.load(JdbcEventListener.class, DefaultJdbcEventListenerFactory.class.getClassLoader());
    private static JdbcEventListener jdbcEventListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JdbcEventListener createJdbcEventListener() {
        if (jdbcEventListener != null) return jdbcEventListener;
        Class<DefaultJdbcEventListenerFactory> clazz = DefaultJdbcEventListenerFactory.class;
        synchronized (DefaultJdbcEventListenerFactory.class) {
            if (jdbcEventListener != null) return jdbcEventListener;
            CompoundJdbcEventListener compoundEventListener = new CompoundJdbcEventListener();
            compoundEventListener.addListender(DefaultEventListener.INSTANCE);
            this.registerEventListenersFromFactories(compoundEventListener);
            this.registerEventListenersFromServiceLoader(compoundEventListener);
            jdbcEventListener = compoundEventListener;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return jdbcEventListener;
        }
    }

    public void clearCache() {
        jdbcEventListener = null;
    }

    protected void registerEventListenersFromFactories(CompoundJdbcEventListener compoundEventListener) {
        List<P6Factory> factories = P6ModuleManager.getInstance().getFactories();
        if (factories != null) {
            for (P6Factory factory : factories) {
                JdbcEventListener eventListener = factory.getJdbcEventListener();
                if (eventListener == null) continue;
                compoundEventListener.addListender(eventListener);
            }
        }
    }

    protected void registerEventListenersFromServiceLoader(CompoundJdbcEventListener compoundEventListener) {
        Iterator<JdbcEventListener> iterator = jdbcEventListenerServiceLoader.iterator();
        while (iterator.hasNext()) {
            try {
                compoundEventListener.addListender(iterator.next());
            }
            catch (ServiceConfigurationError e) {
                e.printStackTrace();
            }
        }
    }
}

