/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import org.evomaster.client.java.controller.api.dto.AuthenticationDto;
import org.evomaster.client.java.controller.api.dto.CookieLoginDto;
import org.evomaster.client.java.controller.api.dto.HeaderDto;

public class AuthUtils {
    public static String encode64(String value) {
        Objects.requireNonNull(value);
        byte[] data = value.getBytes(StandardCharsets.UTF_8);
        byte[] encoded = Base64.getEncoder().encode(data);
        return new String(encoded);
    }

    public static AuthenticationDto getForBasic(String dtoName, String userId, String password) {
        Objects.requireNonNull(userId, password);
        String encoded = AuthUtils.encode64(userId + ":" + password);
        String headerValue = "Basic " + encoded;
        return AuthUtils.getForAuthorizationHeader(dtoName, headerValue);
    }

    public static AuthenticationDto getForAuthorizationHeader(String dtoName, String authorizationValue) {
        AuthenticationDto dto = new AuthenticationDto(dtoName);
        dto.headers.add(new HeaderDto("Authorization", authorizationValue));
        return dto;
    }

    public static AuthenticationDto getForDefaultSpringFormLogin(String dtoName, String username, String password) {
        CookieLoginDto cookie = new CookieLoginDto();
        cookie.httpVerb = CookieLoginDto.HttpVerb.POST;
        cookie.contentType = CookieLoginDto.ContentType.X_WWW_FORM_URLENCODED;
        cookie.usernameField = "username";
        cookie.passwordField = "password";
        cookie.loginEndpointUrl = "/login";
        cookie.username = username;
        cookie.password = password;
        AuthenticationDto dto = new AuthenticationDto(dtoName);
        dto.cookieLogin = cookie;
        return dto;
    }
}

