/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.internal;

import java.sql.Connection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.evomaster.client.java.controller.api.dto.ActionDto;
import org.evomaster.client.java.controller.api.dto.AdditionalInfoDto;
import org.evomaster.client.java.controller.api.dto.ControllerInfoDto;
import org.evomaster.client.java.controller.api.dto.StringSpecializationInfoDto;
import org.evomaster.client.java.controller.api.dto.SutInfoDto;
import org.evomaster.client.java.controller.api.dto.SutRunDto;
import org.evomaster.client.java.controller.api.dto.TargetInfoDto;
import org.evomaster.client.java.controller.api.dto.TestResultsDto;
import org.evomaster.client.java.controller.api.dto.WrappedResponseDto;
import org.evomaster.client.java.controller.api.dto.database.operations.DatabaseCommandDto;
import org.evomaster.client.java.controller.api.dto.problem.RestProblemDto;
import org.evomaster.client.java.controller.db.QueryResult;
import org.evomaster.client.java.controller.db.SqlScriptRunner;
import org.evomaster.client.java.controller.internal.SutController;
import org.evomaster.client.java.controller.problem.ProblemInfo;
import org.evomaster.client.java.controller.problem.RestProblem;
import org.evomaster.client.java.instrumentation.AdditionalInfo;
import org.evomaster.client.java.instrumentation.TargetInfo;
import org.evomaster.client.java.instrumentation.shared.StringSpecializationInfo;
import org.evomaster.client.java.utils.SimpleLogger;

@Path(value="")
@Produces(value={"application/json;charset=utf8;version=1"})
public class EMController {
    private final SutController sutController;
    private String baseUrlOfSUT;
    private static final Set<String> connectedClientsSoFar = new CopyOnWriteArraySet<String>();

    public EMController(SutController sutController) {
        this.sutController = Objects.requireNonNull(sutController);
    }

    private boolean trackRequestSource(HttpServletRequest request) {
        String source = request.getRemoteAddr() + ":" + request.getRemotePort();
        connectedClientsSoFar.add(source);
        return true;
    }

    public static Set<String> getConnectedClientsSoFar() {
        return connectedClientsSoFar;
    }

    public static void resetConnectedClientsSoFar() {
        connectedClientsSoFar.clear();
    }

    @Path(value="/infoSUT")
    @GET
    public Response getSutInfo(@Context HttpServletRequest httpServletRequest) {
        String connectionHeader = httpServletRequest.getHeader("Connection");
        if (connectionHeader == null || !connectionHeader.equalsIgnoreCase("keep-alive")) {
            return Response.status(400).entity(WrappedResponseDto.withError("Requests should always contain a 'Connection: keep-alive'")).build();
        }
        assert (this.trackRequestSource(httpServletRequest));
        if (!this.sutController.verifySqlConnection()) {
            String msg = "SQL drivers are misconfigured. You must use a 'p6spy' wrapper when you run the SUT. For example, a database connection URL like 'jdbc:h2:mem:testdb' should be changed into 'jdbc:p6spy:h2:mem:testdb'. See documentation on how to configure P6Spy.";
            SimpleLogger.error(msg);
            return Response.status(500).entity(WrappedResponseDto.withError(msg)).build();
        }
        SutInfoDto dto = new SutInfoDto();
        dto.isSutRunning = this.sutController.isSutRunning();
        dto.baseUrlOfSUT = this.baseUrlOfSUT;
        dto.infoForAuthentication = this.sutController.getInfoForAuthentication();
        dto.sqlSchemaDto = this.sutController.getSqlDatabaseSchema();
        dto.defaultOutputFormat = this.sutController.getPreferredOutputFormat();
        ProblemInfo info = this.sutController.getProblemInfo();
        if (info == null) {
            String msg = "Undefined problem type in the EM Controller";
            SimpleLogger.error(msg);
            return Response.status(500).entity(WrappedResponseDto.withError(msg)).build();
        }
        if (!(info instanceof RestProblem)) {
            String msg = "Unrecognized problem type: " + info.getClass().getName();
            SimpleLogger.error(msg);
            return Response.status(500).entity(WrappedResponseDto.withError(msg)).build();
        }
        RestProblem rp = (RestProblem)info;
        dto.restProblem = new RestProblemDto();
        dto.restProblem.swaggerJsonUrl = rp.getSwaggerJsonUrl();
        dto.restProblem.endpointsToSkip = rp.getEndpointsToSkip();
        dto.unitsInfoDto = this.sutController.getUnitsInfoDto();
        if (dto.unitsInfoDto == null) {
            String msg = "Failed to extract units info";
            SimpleLogger.error(msg);
            return Response.status(500).entity(WrappedResponseDto.withError(msg)).build();
        }
        return Response.status(200).entity(WrappedResponseDto.withData(dto)).build();
    }

    @Path(value="/controllerInfo")
    @GET
    public Response getControllerInfoDto(@Context HttpServletRequest httpServletRequest) {
        assert (this.trackRequestSource(httpServletRequest));
        ControllerInfoDto dto = new ControllerInfoDto();
        dto.fullName = this.sutController.getClass().getName();
        dto.isInstrumentationOn = this.sutController.isInstrumentationActivated();
        return Response.status(200).entity(WrappedResponseDto.withData(dto)).build();
    }

    @Path(value="/newSearch")
    @POST
    public Response newSearch(@Context HttpServletRequest httpServletRequest) {
        assert (this.trackRequestSource(httpServletRequest));
        this.sutController.newSearch();
        return Response.status(201).entity(WrappedResponseDto.withNoData()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="/runSUT")
    @PUT
    @Consumes(value={"application/json;charset=utf8;version=1"})
    public Response runSut(SutRunDto dto, @Context HttpServletRequest httpServletRequest) {
        assert (this.trackRequestSource(httpServletRequest));
        try {
            if (dto.run == null) {
                String msg = "Invalid JSON: 'run' field is required";
                SimpleLogger.warn(msg);
                return Response.status(400).entity(WrappedResponseDto.withError(msg)).build();
            }
            boolean sqlHeuristics = dto.calculateSqlHeuristics != null && dto.calculateSqlHeuristics != false;
            boolean sqlExecution = dto.extractSqlExecutionInfo != null && dto.extractSqlExecutionInfo != false;
            this.sutController.enableComputeSqlHeuristicsOrExtractExecution(sqlHeuristics, sqlExecution);
            boolean doReset = dto.resetState != null && dto.resetState != false;
            EMController eMController = this;
            synchronized (eMController) {
                if (!dto.run.booleanValue()) {
                    if (doReset) {
                        String msg = "Invalid JSON: cannot reset state and stop service at same time";
                        SimpleLogger.warn(msg);
                        return Response.status(400).entity(WrappedResponseDto.withError(msg)).build();
                    }
                    if (this.sutController.isSutRunning()) {
                        this.sutController.stopSut();
                        this.baseUrlOfSUT = null;
                    }
                } else {
                    if (!this.sutController.isSutRunning()) {
                        this.baseUrlOfSUT = this.sutController.startSut();
                        if (this.baseUrlOfSUT == null) {
                            String msg = "Internal failure: cannot start SUT based on given configuration";
                            SimpleLogger.warn(msg);
                            return Response.status(500).entity(WrappedResponseDto.withError(msg)).build();
                        }
                        this.sutController.initSqlHandler();
                    }
                    if (dto.resetState != null && dto.resetState.booleanValue()) {
                        this.sutController.resetStateOfSUT();
                        this.sutController.newTest();
                    }
                }
            }
        }
        catch (RuntimeException e) {
            String msg = e.getMessage();
            SimpleLogger.error(msg, e);
            return Response.status(500).entity(WrappedResponseDto.withError(msg)).build();
        }
        return Response.status(204).entity(WrappedResponseDto.withNoData()).build();
    }

    @Path(value="/testResults")
    @GET
    public Response getTestResults(@QueryParam(value="ids") @DefaultValue(value="") String idList, @Context HttpServletRequest httpServletRequest) {
        assert (this.trackRequestSource(httpServletRequest));
        try {
            Set<Integer> ids;
            TestResultsDto dto = new TestResultsDto();
            try {
                ids = Arrays.stream(idList.split(",")).filter(s -> !s.trim().isEmpty()).map(Integer::parseInt).collect(Collectors.toSet());
            }
            catch (NumberFormatException e) {
                String msg = "Invalid parameter 'ids': " + e.getMessage();
                SimpleLogger.warn(msg);
                return Response.status(400).entity(WrappedResponseDto.withError(msg)).build();
            }
            List<TargetInfo> targetInfos = this.sutController.getTargetInfos(ids);
            if (targetInfos == null) {
                String msg = "Failed to collect target information for " + ids.size() + " ids";
                SimpleLogger.error(msg);
                return Response.status(500).entity(WrappedResponseDto.withError(msg)).build();
            }
            targetInfos.forEach(t -> {
                TargetInfoDto info = new TargetInfoDto();
                info.id = t.mappedId;
                info.value = t.value;
                info.descriptiveId = t.descriptiveId;
                info.actionIndex = t.actionIndex;
                dto.targets.add(info);
            });
            List<AdditionalInfo> additionalInfos = this.sutController.getAdditionalInfoList();
            if (additionalInfos == null) {
                String msg = "Failed to collect additional info";
                SimpleLogger.error(msg);
                return Response.status(500).entity(WrappedResponseDto.withError(msg)).build();
            }
            additionalInfos.forEach(a -> {
                AdditionalInfoDto info = new AdditionalInfoDto();
                info.queryParameters = new HashSet<String>(a.getQueryParametersView());
                info.headers = new HashSet<String>(a.getHeadersView());
                info.lastExecutedStatement = a.getLastExecutedStatement();
                info.stringSpecializations = new HashMap<String, List<StringSpecializationInfoDto>>();
                for (Map.Entry<String, Set<StringSpecializationInfo>> entry : a.getStringSpecializationsView().entrySet()) {
                    assert (!entry.getValue().isEmpty());
                    List list = entry.getValue().stream().map(it -> new StringSpecializationInfoDto(it.getStringSpecialization().toString(), it.getValue(), it.getType().toString())).collect(Collectors.toList());
                    info.stringSpecializations.put(entry.getKey(), list);
                }
                dto.additionalInfoList.add(info);
            });
            dto.extraHeuristics = this.sutController.getExtraHeuristics();
            return Response.status(200).entity(WrappedResponseDto.withData(dto)).build();
        }
        catch (RuntimeException e) {
            String msg = "Thrown exception: " + e.getMessage();
            SimpleLogger.error(msg, e);
            return Response.status(500).entity(WrappedResponseDto.withError(msg)).build();
        }
    }

    @Path(value="/newAction")
    @Consumes(value={"application/json"})
    @PUT
    public Response newAction(ActionDto dto, @Context HttpServletRequest httpServletRequest) {
        assert (this.trackRequestSource(httpServletRequest));
        this.sutController.newAction(dto);
        return Response.status(204).entity(WrappedResponseDto.withNoData()).build();
    }

    @Path(value="/databaseCommand")
    @Consumes(value={"application/json;charset=utf8;version=1"})
    @POST
    public Response executeDatabaseCommand(DatabaseCommandDto dto, @Context HttpServletRequest httpServletRequest) {
        assert (this.trackRequestSource(httpServletRequest));
        try {
            Connection connection = this.sutController.getConnection();
            if (connection == null) {
                String msg = "No active database connection";
                SimpleLogger.warn(msg);
                return Response.status(400).entity(WrappedResponseDto.withError(msg)).build();
            }
            if (dto.command == null && (dto.insertions == null || dto.insertions.isEmpty())) {
                String msg = "No input command";
                SimpleLogger.warn(msg);
                return Response.status(400).entity(WrappedResponseDto.withError(msg)).build();
            }
            if (dto.command != null && dto.insertions != null && !dto.insertions.isEmpty()) {
                String msg = "Only 1 command can be specified";
                SimpleLogger.warn(msg);
                return Response.status(400).entity(WrappedResponseDto.withError(msg)).build();
            }
            if (dto.insertions != null && dto.insertions.stream().anyMatch(i -> i.targetTable == null || i.targetTable.isEmpty())) {
                String msg = "Insertion with no target table";
                SimpleLogger.warn(msg);
                return Response.status(400).entity(WrappedResponseDto.withError(msg)).build();
            }
            QueryResult queryResult = null;
            Map<Long, Long> idMapping = null;
            try {
                if (dto.command != null) {
                    queryResult = SqlScriptRunner.execCommand(connection, dto.command);
                } else {
                    idMapping = SqlScriptRunner.execInsert(connection, dto.insertions);
                }
            }
            catch (Exception e) {
                String msg = "Failed to execute database command: " + e.getMessage();
                SimpleLogger.warn(msg);
                return Response.status(400).entity(WrappedResponseDto.withError(msg)).build();
            }
            if (queryResult != null) {
                return Response.status(200).entity(WrappedResponseDto.withData(queryResult.toDto())).build();
            }
            if (idMapping != null) {
                return Response.status(200).entity(WrappedResponseDto.withData(idMapping)).build();
            }
            return Response.status(204).entity(WrappedResponseDto.withNoData()).build();
        }
        catch (RuntimeException e) {
            String msg = "Thrown exception: " + e.getMessage();
            SimpleLogger.error(msg, e);
            return Response.status(500).entity(WrappedResponseDto.withError(msg)).build();
        }
    }
}

