/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.evomaster.client.java.instrumentation.coverage.noninteger.NonIntegerComparisons;
import org.evomaster.client.java.instrumentation.shared.ClassName;
import shaded.org.objectweb.asm.Label;
import shaded.org.objectweb.asm.MethodVisitor;

public class NonIntegerComparisonsMethodVisitor
extends MethodVisitor {
    private static final Set<Integer> codes = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(148, 152, 151, 150, 149)));
    private final String className;
    private final String methodName;
    private int currentLine;
    private int currentIndex;

    public NonIntegerComparisonsMethodVisitor(MethodVisitor mv, String className, String methodName, String descriptor) {
        super(458752, mv);
        this.className = className;
        this.methodName = methodName;
        this.currentLine = 0;
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
        this.currentLine = line;
        this.currentIndex = 0;
    }

    @Override
    public void visitInsn(int opcode) {
        String descriptor;
        String name;
        if (!codes.contains(opcode)) {
            super.visitInsn(opcode);
            return;
        }
        String id = this.className + "_" + this.currentLine + "_" + this.currentIndex;
        ++this.currentIndex;
        this.visitLdcInsn(id);
        if (opcode == 148) {
            name = "replaceLCMP";
            descriptor = "(JJLjava/lang/String;)I";
        } else if (opcode == 152) {
            name = "replaceDCMPG";
            descriptor = "(DDLjava/lang/String;)I";
        } else if (opcode == 151) {
            name = "replaceDCMPL";
            descriptor = "(DDLjava/lang/String;)I";
        } else if (opcode == 150) {
            name = "replaceFCMPG";
            descriptor = "(FFLjava/lang/String;)I";
        } else if (opcode == 149) {
            name = "replaceFCMPG";
            descriptor = "(FFLjava/lang/String;)I";
        } else {
            throw new IllegalStateException("BUG: unrecognized code " + opcode);
        }
        this.mv.visitMethodInsn(184, ClassName.get(NonIntegerComparisons.class).getBytecodeName(), name, descriptor, NonIntegerComparisons.class.isInterface());
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        super.visitMaxs(maxStack + 1, maxLocals);
    }
}

