/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement;

import java.util.Objects;
import java.util.regex.Pattern;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.RegexDistanceUtils;
import org.evomaster.client.java.instrumentation.heuristic.Truthness;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.shared.StringSpecialization;
import org.evomaster.client.java.instrumentation.shared.StringSpecializationInfo;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class PatternMatchingHelper {
    public static boolean matches(String regex, String input, String idTemplate) {
        Objects.requireNonNull(regex);
        Objects.requireNonNull(input);
        if (ExecutionTracer.isTaintInput(input)) {
            ExecutionTracer.addStringSpecialization(input, new StringSpecializationInfo(StringSpecialization.REGEX, regex));
        }
        if (idTemplate == null) {
            return Pattern.matches(regex, input);
        }
        boolean matches = Pattern.matches(regex, input);
        if (matches) {
            ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, new Truthness(1.0, 0.0));
        } else {
            int distance = RegexDistanceUtils.getStandardDistance(input.toString(), regex);
            ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, new Truthness(1.0 / (1.0 + (double)distance), 1.0));
        }
        return matches;
    }
}

