/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.util.Objects;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.DistanceHelper;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.heuristic.Truthness;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class CharacterClassReplacement
implements MethodReplacementClass {
    @Override
    public Class<?> getTargetClass() {
        return Character.class;
    }

    @Replacement(type=ReplacementType.BOOLEAN)
    public static boolean equals(Character caller, Object anObject, String idTemplate) {
        Truthness t;
        Objects.requireNonNull(caller);
        if (idTemplate == null) {
            return caller.equals(anObject);
        }
        if (anObject == null || !(anObject instanceof Character)) {
            t = new Truthness(0.05, 1.0);
        } else {
            Character anoterCharacter = (Character)anObject;
            if (caller.equals(anoterCharacter)) {
                t = new Truthness(1.0, 0.0);
            } else {
                double base = 0.1;
                double distance = DistanceHelper.getDistanceToEquality(caller.charValue(), anoterCharacter.charValue());
                double h = 0.1 + 0.9 / (distance + 1.0);
                t = new Truthness(h, 1.0);
            }
        }
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return caller.equals(anObject);
    }
}

