/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.noninteger;

import org.evomaster.client.java.instrumentation.coverage.methodreplacement.DistanceHelper;
import org.evomaster.client.java.instrumentation.heuristic.TruthnessUtils;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class NonIntegerComparisons {
    private static final double REACHED = 0.2;

    private static double heuristic(double distance) {
        double normalized = TruthnessUtils.normalizeValue(distance);
        double score = 1.0 - normalized;
        double scaled = 0.2 + 0.8 * score;
        return scaled;
    }

    public static int replaceLCMP(long a, long b, String id) {
        int res;
        double distance = DistanceHelper.getDistanceToEquality(a, b);
        double less = 0.0;
        double eq = 0.0;
        double greater = 0.0;
        if (a == b) {
            less = 0.2;
            eq = 1.0;
            greater = 0.2;
            res = 0;
        } else if (a < b) {
            less = 1.0;
            eq = NonIntegerComparisons.heuristic(distance);
            greater = NonIntegerComparisons.heuristic(DistanceHelper.increasedDistance(distance, 1.0));
            res = -1;
        } else {
            assert (a > b);
            less = NonIntegerComparisons.heuristic(DistanceHelper.increasedDistance(distance, 1.0));
            eq = NonIntegerComparisons.heuristic(distance);
            greater = 1.0;
            res = 1;
        }
        ExecutionTracer.executedNumericComparison(id, less, eq, greater);
        return res;
    }

    public static int replaceDCMPG(double a, double b, String id) {
        return NonIntegerComparisons.replaceDCMP(a, b, id, 1);
    }

    public static int replaceDCMPL(double a, double b, String id) {
        return NonIntegerComparisons.replaceDCMP(a, b, id, -1);
    }

    public static int replaceFCMPG(float a, float b, String id) {
        return NonIntegerComparisons.replaceDCMP(a, b, id, 1);
    }

    public static int replaceFCMPL(float a, float b, String id) {
        return NonIntegerComparisons.replaceDCMP(a, b, id, -1);
    }

    private static int replaceDCMP(double a, double b, String id, int resWhenNotFinite) {
        int res;
        double less = 0.0;
        double eq = 0.0;
        double greater = 0.0;
        if (!Double.isFinite(a) || !Double.isFinite(b)) {
            less = 0.2;
            eq = 0.2;
            greater = 0.2;
            res = resWhenNotFinite;
        } else {
            double distance = DistanceHelper.getDistanceToEquality(a, b);
            if (a == b) {
                less = 0.2;
                eq = 1.0;
                greater = 0.2;
                res = 0;
            } else if (a < b) {
                less = 1.0;
                eq = NonIntegerComparisons.heuristic(distance);
                greater = NonIntegerComparisons.heuristic(DistanceHelper.increasedDistance(distance, 1.0));
                res = -1;
            } else {
                assert (a > b);
                less = NonIntegerComparisons.heuristic(DistanceHelper.increasedDistance(distance, 1.0));
                eq = NonIntegerComparisons.heuristic(distance);
                greater = 1.0;
                res = 1;
            }
        }
        ExecutionTracer.executedNumericComparison(id, less, eq, greater);
        return res;
    }
}

