/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.staticstate;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;

public class UnitsInfoRecorder
implements Serializable {
    private static UnitsInfoRecorder singleton = new UnitsInfoRecorder();
    private Set<String> unitNames = new CopyOnWriteArraySet<String>();
    private AtomicInteger numberOfLines = new AtomicInteger(0);
    private AtomicInteger numberOfBranches = new AtomicInteger(0);
    private AtomicInteger numberOfReplacedMethodsInSut = new AtomicInteger(0);
    private AtomicInteger numberOfReplacedMethodsInThirdParty = new AtomicInteger(0);
    private AtomicInteger numberOfTrackedMethods = new AtomicInteger(0);

    private UnitsInfoRecorder() {
    }

    public static void reset() {
        singleton = new UnitsInfoRecorder();
    }

    public static UnitsInfoRecorder getInstance() {
        return singleton;
    }

    public static void markNewUnit(String name) {
        UnitsInfoRecorder.singleton.unitNames.add(name);
    }

    public static void markNewLine() {
        UnitsInfoRecorder.singleton.numberOfLines.incrementAndGet();
    }

    public static void markNewBranchPair() {
        UnitsInfoRecorder.singleton.numberOfBranches.addAndGet(2);
    }

    public static void markNewReplacedMethodInSut() {
        UnitsInfoRecorder.singleton.numberOfReplacedMethodsInSut.incrementAndGet();
    }

    public static void markNewReplacedMethodInThirdParty() {
        UnitsInfoRecorder.singleton.numberOfReplacedMethodsInThirdParty.incrementAndGet();
    }

    public static void markNewTrackedMethod() {
        UnitsInfoRecorder.singleton.numberOfTrackedMethods.incrementAndGet();
    }

    public int getNumberOfUnits() {
        return this.unitNames.size();
    }

    public Set<String> getUnitNames() {
        return Collections.unmodifiableSet(this.unitNames);
    }

    public int getNumberOfLines() {
        return this.numberOfLines.get();
    }

    public int getNumberOfBranches() {
        return this.numberOfBranches.get();
    }

    public int getNumberOfReplacedMethodsInSut() {
        return this.numberOfReplacedMethodsInSut.get();
    }

    public int getNumberOfReplacedMethodsInThirdParty() {
        return this.numberOfReplacedMethodsInThirdParty.get();
    }

    public int getNumberOfTrackedMethods() {
        return this.numberOfTrackedMethods.get();
    }
}

