/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.tracker;

import org.evomaster.client.java.instrumentation.Constants;
import org.evomaster.client.java.instrumentation.shared.ClassName;
import org.evomaster.client.java.instrumentation.tracker.TrackerMethodVisitor;
import shaded.org.objectweb.asm.ClassVisitor;
import shaded.org.objectweb.asm.MethodVisitor;

public class TrackerClassVisitor
extends ClassVisitor {
    private final String bytecodeClassName;

    public TrackerClassVisitor(ClassVisitor classVisitor, ClassName className) {
        super(458752, classVisitor);
        this.bytecodeClassName = className.getBytecodeName();
    }

    @Override
    public MethodVisitor visitMethod(int methodAccess, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(methodAccess, name, descriptor, signature, exceptions);
        if (Constants.isMethodSyntheticOrBridge(methodAccess)) {
            return mv;
        }
        if (name.equals("<clinit>")) {
            return mv;
        }
        mv = new TrackerMethodVisitor(mv, this.bytecodeClassName, name, descriptor);
        return mv;
    }
}

