/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jgrapht.experimental.equivalence;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import shaded.org.jgrapht.experimental.equivalence.EquivalenceComparator;
import shaded.org.jgrapht.experimental.equivalence.EquivalenceComparatorChain;

public class EquivalenceComparatorChainBase<E, C>
implements EquivalenceComparatorChain<E, C> {
    private List<EquivalenceComparator<? super E, ? super C>> chain = new LinkedList<EquivalenceComparator<? super E, ? super C>>();

    public EquivalenceComparatorChainBase(EquivalenceComparator<E, C> equivalenceComparator) {
        this.chain.add(equivalenceComparator);
    }

    @Override
    public void appendComparator(EquivalenceComparator equivalenceComparator) {
        if (equivalenceComparator != null) {
            this.chain.add(equivalenceComparator);
        }
    }

    @Override
    public boolean equivalenceCompare(E e, E e2, C c, C c2) {
        for (EquivalenceComparator<E, C> equivalenceComparator : this.chain) {
            if (equivalenceComparator.equivalenceCompare(e, e2, c, c2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int equivalenceHashcode(E e, C c) {
        StringBuffer stringBuffer = new StringBuffer();
        ListIterator<EquivalenceComparator<E, C>> listIterator = this.chain.listIterator();
        while (listIterator.hasNext()) {
            EquivalenceComparator<E, C> equivalenceComparator = listIterator.next();
            int n = equivalenceComparator.equivalenceHashcode(e, c);
            stringBuffer.append(n);
            if (!listIterator.hasNext()) continue;
            stringBuffer.append('+');
        }
        return stringBuffer.toString().hashCode();
    }
}

