/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.contentMatchers;

import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class NumberMatcher
extends TypeSafeMatcher<Number> {
    private final double value;

    public NumberMatcher(double value) {
        this.value = value;
    }

    public void describeTo(Description description) {
        description.appendValue((Object)this.value);
    }

    protected boolean matchesSafely(Number item) {
        if (item == null) {
            return false;
        }
        return item.doubleValue() == this.value;
    }

    public static NumberMatcher numberMatches(Number item) {
        return new NumberMatcher(item.doubleValue());
    }

    public static NumberMatcher numberMatches(String item) {
        try {
            Double value = Double.parseDouble(item);
            return new NumberMatcher(value);
        }
        catch (NumberFormatException e) {
            return new NumberMatcher(Double.NaN);
        }
    }

    public static boolean numbersMatch(Number item1, Number item2) {
        if (item1 == null || item2 == null) {
            return false;
        }
        NumberMatcher n1 = new NumberMatcher(item1.doubleValue());
        return n1.matchesSafely(item2);
    }

    public static boolean numbersMatch(Number item1, String item2) {
        if (item1 == null || item2 == null) {
            return false;
        }
        NumberMatcher n2 = NumberMatcher.numberMatches(item2);
        return n2.matchesSafely(item1);
    }
}

