/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem;

import java.util.ArrayList;
import java.util.List;
import org.evomaster.client.java.controller.problem.ProblemInfo;

public class RestProblem
implements ProblemInfo {
    private final String openApiUrl;
    private final List<String> endpointsToSkip;
    private final String openApiSchema;

    public RestProblem(String openApiUrl, List<String> endpointsToSkip) {
        this(openApiUrl, endpointsToSkip, null);
    }

    public RestProblem(String openApiUrl, List<String> endpointsToSkip, String openApiSchema) {
        boolean schema;
        this.openApiUrl = openApiUrl;
        this.endpointsToSkip = endpointsToSkip == null ? new ArrayList<String>() : new ArrayList<String>(endpointsToSkip);
        this.openApiSchema = openApiSchema;
        boolean url = openApiUrl != null && !openApiUrl.isEmpty();
        boolean bl = schema = openApiSchema != null && !openApiSchema.isEmpty();
        if (!url && !schema) {
            throw new IllegalArgumentException("MUST either provide a URL or a full schema for OpenAPI");
        }
        if (url && schema) {
            throw new IllegalArgumentException("Cannot specify BOTH a URL and a whole schema. Choose one only");
        }
    }

    public String getOpenApiUrl() {
        return this.openApiUrl;
    }

    public List<String> getEndpointsToSkip() {
        return this.endpointsToSkip;
    }

    public String getOpenApiSchema() {
        return this.openApiSchema;
    }
}

