/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.params;

import org.evomaster.client.java.controller.api.dto.problem.rpc.ParamDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.RPCSupportedDataType;
import org.evomaster.client.java.controller.problem.rpc.schema.params.PrimitiveOrWrapperParam;
import org.evomaster.client.java.controller.problem.rpc.schema.types.AccessibleSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.types.PrimitiveOrWrapperType;

public class ByteParam
extends PrimitiveOrWrapperParam<Byte> {
    public static final String TYPE_NAME = Byte.TYPE.getSimpleName();
    public static final String FULL_TYPE_NAME = Byte.TYPE.getName();

    public ByteParam(String name, String type, String fullTypeName, Class<?> clazz, AccessibleSchema accessibleSchema) {
        super(name, type, fullTypeName, clazz, accessibleSchema);
    }

    public ByteParam(String name, PrimitiveOrWrapperType type, AccessibleSchema accessibleSchema) {
        super(name, type, accessibleSchema);
    }

    @Override
    public String getValueAsJavaString() {
        if (this.getValue() == null) {
            return null;
        }
        return "" + this.getValue();
    }

    @Override
    public ParamDto getDto() {
        ParamDto dto = super.getDto();
        dto.type.type = ((PrimitiveOrWrapperType)this.getType()).isWrapper ? RPCSupportedDataType.BYTE : RPCSupportedDataType.P_BYTE;
        if (this.getValue() != null) {
            dto.stringValue = ((Byte)this.getValue()).toString();
        }
        return dto;
    }

    public ByteParam copyStructure() {
        return new ByteParam(this.getName(), (PrimitiveOrWrapperType)this.getType(), this.accessibleSchema);
    }

    @Override
    public void setValueBasedOnStringValue(String stringValue) {
        try {
            if (stringValue != null) {
                this.setValue(Byte.parseByte(stringValue));
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("ERROR: fail to convert " + stringValue + " as byte value");
        }
    }

    @Override
    protected void setValueBasedOnValidInstance(Object instance) {
        this.setValue((Byte)instance);
    }

    @Override
    public boolean isValidInstance(Object instance) {
        return instance instanceof Byte;
    }

    @Override
    public String getPrimitiveValue(String responseVarName) {
        if (((PrimitiveOrWrapperType)this.getType()).isWrapper) {
            return responseVarName + ".byteValue()";
        }
        return responseVarName;
    }

    @Override
    public String getCastType() {
        return Byte.TYPE.getName();
    }
}

