/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.params;

import org.evomaster.client.java.controller.api.dto.problem.rpc.ParamDto;
import org.evomaster.client.java.controller.problem.rpc.schema.params.NamedTypedValue;
import org.evomaster.client.java.controller.problem.rpc.schema.types.AccessibleSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.types.CollectionType;

public abstract class CollectionParam<V>
extends NamedTypedValue<CollectionType, V> {
    private Integer minSize;
    private Integer maxSize;

    public CollectionParam(String name, CollectionType type, AccessibleSchema accessibleSchema) {
        super(name, type, accessibleSchema);
    }

    public Integer getMinSize() {
        return this.minSize;
    }

    public void setMinSize(Integer minSize) {
        if (this.minSize != null && this.minSize >= minSize) {
            return;
        }
        this.minSize = minSize;
    }

    public Integer getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public ParamDto getDto() {
        ParamDto dto = super.getDto();
        if (this.maxSize != null) {
            dto.maxSize = (long)this.maxSize;
        }
        if (this.minSize != null) {
            dto.minSize = (long)this.minSize;
        }
        return dto;
    }

    @Override
    public void copyProperties(NamedTypedValue copy) {
        super.copyProperties(copy);
        if (copy instanceof CollectionParam) {
            ((CollectionParam)copy).setMinSize(this.minSize);
            ((CollectionParam)copy).setMaxSize(this.maxSize);
        }
    }
}

