/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.params;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.evomaster.client.java.controller.api.dto.problem.rpc.ParamDto;
import org.evomaster.client.java.controller.problem.rpc.schema.params.PrimitiveOrWrapperParam;
import org.evomaster.client.java.controller.problem.rpc.schema.types.AccessibleSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.types.PrimitiveOrWrapperType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.TypeSchema;
import shaded.com.fasterxml.jackson.core.JsonProcessingException;
import shaded.com.fasterxml.jackson.databind.ObjectMapper;

public abstract class NamedTypedValue<T extends TypeSchema, V> {
    public static final String NOT_NULL_MARK_OBJ_DATE = "{}";
    private static final ObjectMapper objectMaper = new ObjectMapper();
    private final String name;
    private final T type;
    private V value;
    private boolean isNullable = true;
    private boolean isMutable = true;
    private NamedTypedValue defaultValue;
    public final AccessibleSchema accessibleSchema;
    private boolean hasDependentCandidates = false;
    private List<NamedTypedValue> candidates;
    private List<String> candidateReferences;

    public boolean isHasDependentCandidates() {
        return this.hasDependentCandidates;
    }

    public void setHasDependentCandidates(boolean hasDependentCandidates) {
        this.hasDependentCandidates = hasDependentCandidates;
    }

    public List<NamedTypedValue> getCandidates() {
        return this.candidates;
    }

    public void setCandidates(List<NamedTypedValue> candidates) {
        this.candidates = candidates;
    }

    public List<String> getCandidateReferences() {
        return this.candidateReferences;
    }

    public void setCandidateReferences(List<String> candidateReferences) {
        this.candidateReferences = candidateReferences;
    }

    public NamedTypedValue(String name, T type, AccessibleSchema accessibleSchema) {
        this.name = name;
        this.type = type;
        this.accessibleSchema = accessibleSchema;
    }

    public String getName() {
        return this.name;
    }

    public T getType() {
        return this.type;
    }

    public V getValue() {
        return this.value;
    }

    public abstract Object newInstance() throws ClassNotFoundException;

    public void setValue(V value) {
        this.value = value;
    }

    public void setNullable(boolean nullable) {
        this.isNullable = nullable;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public ParamDto getDto() {
        ParamDto dto = new ParamDto();
        dto.name = this.name;
        dto.type = ((TypeSchema)this.type).getDto();
        dto.isNullable = this.isNullable;
        if (this.candidates != null) {
            dto.candidates = this.candidates.stream().map(NamedTypedValue::getDto).collect(Collectors.toList());
        }
        if (this.candidateReferences != null) {
            dto.candidateReferences = new ArrayList<String>(this.candidateReferences);
        }
        dto.isMutable = this.isMutable;
        if (this.defaultValue != null) {
            dto.defaultValue = this.defaultValue.getDto();
        }
        return dto;
    }

    public NamedTypedValue<T, V> copyStructureWithProperties() {
        NamedTypedValue<T, V> copy = this.copyStructure();
        this.copyProperties(copy);
        return copy;
    }

    public abstract NamedTypedValue<T, V> copyStructure();

    public void copyProperties(NamedTypedValue copy) {
        copy.setNullable(this.isNullable);
        copy.setHasDependentCandidates(this.isHasDependentCandidates());
        copy.setMutable(this.isMutable());
        copy.setDefaultValue(this.getDefaultValue());
        if (this.getCandidates() != null && !this.getCandidates().isEmpty()) {
            copy.setCandidates(this.getCandidates().stream().map(c -> c.copyStructureWithProperties()).collect(Collectors.toList()));
        }
        if (this.getCandidateReferences() != null && !this.getCandidateReferences().isEmpty()) {
            copy.setCandidateReferences(new ArrayList<String>(this.getCandidateReferences()));
        }
    }

    public boolean sameParam(ParamDto dto) {
        return dto.name.equals(this.name) && ((TypeSchema)this.type).sameType(dto.type);
    }

    public abstract void setValueBasedOnDto(ParamDto var1);

    public void setValueBasedOnInstance(Object instance) {
        if (instance == null) {
            return;
        }
        if (!this.isValidInstance(instance)) {
            throw new IllegalStateException("class of the instance (" + instance.getClass().getName() + ") does not conform with this param: " + ((TypeSchema)this.getType()).getFullTypeName());
        }
        this.setValueBasedOnValidInstance(instance);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValueBasedOnInstanceOrJson(Object json) throws JsonProcessingException {
        Object instance = null;
        if (!this.isValidInstance(json)) {
            if (json instanceof String) {
                instance = this.parseValueWithJson((String)json);
            } else {
                if (!PrimitiveOrWrapperType.isPrimitiveOrTypes(json.getClass())) throw new RuntimeException("Fail to extract value from json for " + ((TypeSchema)this.getType()).getFullTypeName());
                instance = ((PrimitiveOrWrapperParam)this).convertValueTo(json);
            }
        } else {
            instance = json;
        }
        this.setValueBasedOnInstance(instance);
    }

    public Object parseValueWithJson(String json) throws JsonProcessingException {
        return objectMaper.readValue(json, ((TypeSchema)this.getType()).getClazz());
    }

    protected abstract void setValueBasedOnValidInstance(Object var1);

    public boolean isValidInstance(Object instance) {
        return ((TypeSchema)this.getType()).getClazz().isInstance(instance);
    }

    public abstract List<String> newInstanceWithJava(boolean var1, boolean var2, String var3, int var4);

    public List<String> newInstanceWithJava(int indent) {
        return this.newInstanceWithJava(true, true, this.getName(), indent);
    }

    public abstract List<String> newAssertionWithJava(int var1, String var2, int var3);

    public List<String> newAssertionWithJava(String responseVarName, int maxAssertionForDataInCollection) {
        return this.newAssertionWithJava(0, responseVarName, maxAssertionForDataInCollection);
    }

    public abstract String getValueAsJavaString();

    public boolean isMutable() {
        return this.isMutable;
    }

    public void setMutable(boolean mutable) {
        this.isMutable = mutable;
    }

    public NamedTypedValue getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(NamedTypedValue defaultValue) {
        this.defaultValue = defaultValue;
    }
}

