/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.params;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.evomaster.client.java.controller.api.dto.problem.rpc.ParamDto;
import org.evomaster.client.java.controller.problem.rpc.CodeJavaGenerator;
import org.evomaster.client.java.controller.problem.rpc.schema.params.BigDecimalParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.BigIntegerParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.CollectionParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.DateParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.MapParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.NamedTypedValue;
import org.evomaster.client.java.controller.problem.rpc.schema.params.PrimitiveOrWrapperParam;
import org.evomaster.client.java.controller.problem.rpc.schema.types.AccessibleSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.types.ObjectType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.PrimitiveOrWrapperType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.TypeSchema;
import org.evomaster.client.java.utils.SimpleLogger;
import shaded.com.fasterxml.jackson.core.JsonProcessingException;

public class ObjectParam
extends NamedTypedValue<ObjectType, List<NamedTypedValue>> {
    public ObjectParam(String name, ObjectType type, AccessibleSchema accessibleSchema) {
        super(name, type, accessibleSchema);
    }

    @Override
    public Object newInstance() throws ClassNotFoundException {
        if (this.getValue() == null) {
            return null;
        }
        String clazzName = ((ObjectType)this.getType()).getFullTypeName();
        Class<?> clazz = Class.forName(clazzName);
        try {
            Object instance = clazz.newInstance();
            for (NamedTypedValue v : (List)this.getValue()) {
                if (v.accessibleSchema == null || v.accessibleSchema.isAccessible) {
                    Field f = clazz.getField(v.getName());
                    f.setAccessible(true);
                    Object vins = v.newInstance();
                    if (vins == null) continue;
                    f.set(instance, vins);
                    continue;
                }
                if (v.accessibleSchema.setterMethodName == null) continue;
                Method m = this.getSetter(clazz, v.accessibleSchema.setterMethodName, (TypeSchema)v.getType(), ((TypeSchema)v.getType()).getClazz(), 0);
                m.invoke(instance, v.newInstance());
            }
            return instance;
        }
        catch (InstantiationException e) {
            throw new RuntimeException("fail to construct the class:" + clazzName + " with error msg:" + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("fail to access the class:" + clazzName + " with error msg:" + e.getMessage());
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("fail to access the field:" + clazzName + " with error msg:" + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("fail to access the method:" + clazzName + " with error msg:" + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("fail to invoke the setter method:" + clazzName + " with error msg:" + e.getMessage());
        }
    }

    private Method getSetter(Class<?> clazz, String setterName, TypeSchema type, Class<?> typeClass, int attemptTimes) throws NoSuchMethodException {
        try {
            Method m = clazz.getMethod(setterName, type.getClazz());
            return m;
        }
        catch (NoSuchMethodException e) {
            Type p;
            if (type instanceof PrimitiveOrWrapperType && attemptTimes == 0 && (p = PrimitiveOrWrapperParam.getPrimitiveOrWrapper(type.getClazz())) instanceof Class) {
                return this.getSetter(clazz, setterName, type, (Class)p, 1);
            }
            throw e;
        }
    }

    public ObjectParam copyStructure() {
        return new ObjectParam(this.getName(), (ObjectType)this.getType(), this.accessibleSchema);
    }

    @Override
    public ParamDto getDto() {
        ParamDto dto = super.getDto();
        if (this.getValue() != null) {
            dto.innerContent = ((List)this.getValue()).stream().map(NamedTypedValue::getDto).collect(Collectors.toList());
            dto.stringValue = "{}";
        } else {
            dto.innerContent = ((ObjectType)this.getType()).getFields().stream().map(NamedTypedValue::getDto).collect(Collectors.toList());
        }
        return dto;
    }

    @Override
    public void setValueBasedOnDto(ParamDto dto) {
        if (dto.innerContent != null && !dto.innerContent.isEmpty()) {
            List<NamedTypedValue> fields = ((ObjectType)this.getType()).getFields();
            ArrayList values = new ArrayList();
            for (ParamDto p : dto.innerContent) {
                NamedTypedValue f = fields.stream().filter(s -> s.sameParam(p)).findFirst().get().copyStructureWithProperties();
                f.setValueBasedOnDto(p);
                values.add(f);
            }
            this.setValue(values);
        }
    }

    @Override
    protected void setValueBasedOnValidInstance(Object instance) {
        Class<?> clazz;
        ArrayList values = new ArrayList();
        List<NamedTypedValue> fields = ((ObjectType)this.getType()).getFields();
        try {
            clazz = Class.forName(((ObjectType)this.getType()).getFullTypeName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("ERROR: fail to get class with the name" + ((ObjectType)this.getType()).getFullTypeName() + " Msg:" + e.getMessage());
        }
        for (NamedTypedValue f : fields) {
            NamedTypedValue copy = f.copyStructureWithProperties();
            try {
                if (f.accessibleSchema == null || f.accessibleSchema.isAccessible) {
                    Field fi = clazz.getField(f.getName());
                    fi.setAccessible(true);
                    Object fiv = fi.get(instance);
                    copy.setValueBasedOnInstance(fiv);
                } else if (f.accessibleSchema.getterMethodName != null) {
                    Method m = clazz.getMethod(f.accessibleSchema.getterMethodName, new Class[0]);
                    copy.setValueBasedOnInstance(m.invoke(instance, new Object[0]));
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException("ERROR: fail to get value of the field with the name (" + f.getName() + ") and error Msg:" + e.getMessage());
            }
            catch (NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("ERROR: fail to get/invoke getter method for the field with the name (" + f.getName() + ") and error Msg:" + e.getMessage());
            }
            values.add(copy);
        }
        this.setValue(values);
    }

    @Override
    public void setValueBasedOnInstanceOrJson(Object json) throws JsonProcessingException {
        Object instance = json;
        if (json instanceof String) {
            instance = this.parseValueWithJson((String)json);
        }
        if (this.isValidInstance(instance)) {
            this.setValueBasedOnInstance(instance);
        } else {
            ArrayList values = new ArrayList();
            List<NamedTypedValue> fields = ((ObjectType)this.getType()).getFields();
            if (!(instance instanceof Map)) {
                throw new RuntimeException("cannot parse the map param " + this.getName() + " with the type" + instance.getClass().getName());
            }
            for (NamedTypedValue f : fields) {
                NamedTypedValue copy = f.copyStructureWithProperties();
                Object fiv = ((Map)instance).get(f.getName());
                copy.setValueBasedOnInstanceOrJson(fiv);
                values.add(copy);
            }
            this.setValue(values);
        }
    }

    @Override
    public List<String> newInstanceWithJava(boolean isDeclaration, boolean doesIncludeName, String variableName, int indent) {
        String typeName = ((ObjectType)this.getType()).getTypeNameForInstance();
        String varName = variableName;
        ArrayList<String> codes = new ArrayList<String>();
        boolean isNull = this.getValue() == null;
        String var = CodeJavaGenerator.oneLineInstance(isDeclaration, doesIncludeName, typeName, varName, null);
        CodeJavaGenerator.addCode(codes, var, indent);
        if (isNull) {
            return codes;
        }
        CodeJavaGenerator.addCode(codes, "{", indent);
        CodeJavaGenerator.addCode(codes, CodeJavaGenerator.setInstanceObject(typeName, varName), indent + 1);
        for (NamedTypedValue f : (List)this.getValue()) {
            String fName;
            if (f.accessibleSchema == null || f.accessibleSchema.isAccessible) {
                fName = varName + "." + f.getName();
                codes.addAll(f.newInstanceWithJava(false, true, fName, indent + 1));
                continue;
            }
            fName = varName;
            boolean fdeclar = false;
            if (f instanceof ObjectParam || f instanceof MapParam || f instanceof CollectionParam || f instanceof DateParam || f instanceof BigDecimalParam || f instanceof BigIntegerParam) {
                fName = varName + "_" + f.getName();
                fdeclar = true;
            }
            codes.addAll(f.newInstanceWithJava(fdeclar, true, fName, indent + 1));
            if (!(f instanceof ObjectParam) && !(f instanceof MapParam) && !(f instanceof CollectionParam) && !(f instanceof DateParam) && !(f instanceof BigDecimalParam) && !(f instanceof BigIntegerParam)) continue;
            CodeJavaGenerator.addCode(codes, CodeJavaGenerator.methodInvocation(varName, f.accessibleSchema.setterMethodName, fName) + CodeJavaGenerator.appendLast(), indent + 1);
        }
        CodeJavaGenerator.addCode(codes, "}", indent);
        return codes;
    }

    @Override
    public List<String> newAssertionWithJava(int indent, String responseVarName, int maxAssertionForDataInCollection) {
        ArrayList<String> codes = new ArrayList<String>();
        if (this.getValue() == null) {
            CodeJavaGenerator.addCode(codes, CodeJavaGenerator.junitAssertNull(responseVarName), indent);
            return codes;
        }
        for (NamedTypedValue f : (List)this.getValue()) {
            String fName = null;
            if (f.accessibleSchema == null || f.accessibleSchema.isAccessible) {
                fName = responseVarName + "." + f.getName();
            } else if (f.accessibleSchema.getterMethodName == null) {
                String msg = "Error: Object(" + ((ObjectType)this.getType()).getFullTypeName() + ") has private field " + f.getName() + ", but there is no getter method";
                SimpleLogger.uniqueWarn(msg);
                CodeJavaGenerator.addComment(codes, msg, indent);
            } else {
                fName = responseVarName + "." + f.accessibleSchema.getterMethodName + "()";
            }
            if (fName == null) continue;
            codes.addAll(f.newAssertionWithJava(indent, fName, maxAssertionForDataInCollection));
        }
        return codes;
    }

    @Override
    public String getValueAsJavaString() {
        return null;
    }
}

