/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.types;

import java.util.ArrayList;
import java.util.List;
import org.evomaster.client.java.controller.api.dto.problem.rpc.RPCSupportedDataType;
import org.evomaster.client.java.controller.api.dto.problem.rpc.TypeDto;
import org.evomaster.client.java.controller.problem.rpc.CodeJavaGenerator;
import org.evomaster.client.java.controller.problem.rpc.schema.params.NamedTypedValue;
import org.evomaster.client.java.controller.problem.rpc.schema.types.TypeSchema;

public class ObjectType
extends TypeSchema {
    private final List<NamedTypedValue> fields;
    private final List<String> genericTypes;

    public ObjectType(String type, String fullTypeName, List<NamedTypedValue> fields, Class<?> clazz, List<String> genericTypes) {
        super(type, fullTypeName, clazz);
        this.fields = fields;
        this.genericTypes = genericTypes;
    }

    public List<NamedTypedValue> getFields() {
        return this.fields;
    }

    @Override
    public TypeDto getDto() {
        TypeDto dto = super.getDto();
        dto.depth = this.depth;
        dto.type = RPCSupportedDataType.CUSTOM_OBJECT;
        return dto;
    }

    @Override
    public ObjectType copy() {
        ArrayList<NamedTypedValue> cfields = new ArrayList<NamedTypedValue>();
        if (this.fields != null) {
            for (NamedTypedValue f : this.fields) {
                cfields.add(f.copyStructureWithProperties());
            }
        }
        ArrayList<String> genericTypes = this.genericTypes != null ? new ArrayList<String>(this.genericTypes) : null;
        ObjectType objectType = new ObjectType(this.getType(), this.getFullTypeName(), cfields, this.getClazz(), genericTypes);
        objectType.depth = this.depth;
        return objectType;
    }

    @Override
    public String getFullTypeNameWithGenericType() {
        if (this.genericTypes == null || this.genericTypes.isEmpty()) {
            return this.getFullTypeName();
        }
        return CodeJavaGenerator.handleClassNameWithGeneric(this.getFullTypeName(), this.genericTypes);
    }
}

